
import math 
import ufl
from dolfin import *

dolfin_set("form compiler", "sfc")

class Source(Function): 
    def eval(self, values, x): 
        values[0] = -2 + math.exp(x[0]*x[0]) 


class Solution(Function): 
    def eval(self, values, x): 
        values[0] = x[0]*x[0] 

class DirichletBoundary(SubDomain): 
    def inside(self, x, on_boundary): 
        return bool(on_boundary)

# Geometry
N = 80  

mesh = UnitSquare(N,N)

# Function spaces
X = FunctionSpace(mesh, 'CG', 1)

# function 
U = Function(X)

# Basis functions 
v = TestFunction(X)
u = TrialFunction(X)

# Source term 
source = Source(X)

# Forms
F = inner(grad(U),grad(v))*dx + ufl.exp(U)*v*dx  
J = derivative(F, U, u)

# Analytical solution 
solution = Solution(X)
sol = project(solution,X)


# Solve nonlinear variational problem
dirichlet_boundary = DirichletBoundary()
bc = DirichletBC(X, solution, dirichlet_boundary)
#problem = VariationalProblem(J, F, bc, nonlinear=True)

problem = VariationalProblem(J, F, bc, nonlinear=True)
problem.solve(U)

plot(sol)
plot(U)
interactive()

# Write solution to file
file = File("u.pvd") 
file << U 

file = File("sol.pvd") 
file << sol 


