/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.DNDEvent;
import org.eclipse.swt.dnd.DNDListener;
import org.eclipse.swt.dnd.DragUnderEffect;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.NoDragUnderEffect;
import org.eclipse.swt.dnd.TableDragUnderEffect;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.dnd.TreeDragUnderEffect;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GdkDragContext;
import org.eclipse.swt.internal.gtk.GtkSelectionData;
import org.eclipse.swt.internal.gtk.GtkTargetEntry;
import org.eclipse.swt.internal.gtk.GtkTargetPair;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;

public class DropTarget
extends Widget {
    private Control control;
    private Listener controlListener;
    private Transfer[] transferAgents = new Transfer[0];
    private DragUnderEffect effect;
    private TransferData selectedDataType;
    private int selectedOperation;
    private int keyOperation = -1;
    private long dragOverStart;
    private Runnable dragOverHeartbeat;
    private DNDEvent dragOverEvent;
    private int drag_motion_handler;
    private int drag_leave_handler;
    private int drag_data_received_handler;
    private int drag_drop_handler;
    private static final String DROPTARGETID = "DropTarget";
    private static final int DRAGOVER_HYSTERESIS = 50;
    private static Callback Drag_Motion;
    private static Callback Drag_Leave;
    private static Callback Drag_Data_Received;
    private static Callback Drag_Drop;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.dnd.DropTarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Drag_Motion = new Callback(clazz, "Drag_Motion", 5);
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.swt.dnd.DropTarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Drag_Leave = new Callback(clazz2, "Drag_Leave", 3);
        Class<?> clazz3 = class$0;
        if (clazz3 == null) {
            try {
                clazz3 = class$0 = Class.forName("org.eclipse.swt.dnd.DropTarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Drag_Data_Received = new Callback(clazz3, "Drag_Data_Received", 7);
        Class<?> clazz4 = class$0;
        if (clazz4 == null) {
            try {
                clazz4 = class$0 = Class.forName("org.eclipse.swt.dnd.DropTarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Drag_Drop = new Callback(clazz4, "Drag_Drop", 5);
    }

    public DropTarget(Control control, int style) {
        super(control, DropTarget.checkStyle(style));
        this.control = control;
        if (Drag_Motion == null || Drag_Leave == null || Drag_Data_Received == null || Drag_Drop == null) {
            DND.error(2001);
        }
        if (control.getData(DROPTARGETID) != null) {
            DND.error(2001);
        }
        control.setData(DROPTARGETID, this);
        byte[] buffer = Converter.wcsToMbcs(null, "drag_motion", true);
        this.drag_motion_handler = OS.g_signal_connect((int)control.handle, (byte[])buffer, (int)Drag_Motion.getAddress(), (int)0);
        buffer = Converter.wcsToMbcs(null, "drag_leave", true);
        this.drag_leave_handler = OS.g_signal_connect((int)control.handle, (byte[])buffer, (int)Drag_Leave.getAddress(), (int)0);
        buffer = Converter.wcsToMbcs(null, "drag_data_received", true);
        this.drag_data_received_handler = OS.g_signal_connect((int)control.handle, (byte[])buffer, (int)Drag_Data_Received.getAddress(), (int)0);
        buffer = Converter.wcsToMbcs(null, "drag_drop", true);
        this.drag_drop_handler = OS.g_signal_connect((int)control.handle, (byte[])buffer, (int)Drag_Drop.getAddress(), (int)0);
        this.controlListener = new Listener(){

            public void handleEvent(Event event) {
                if (!DropTarget.this.isDisposed()) {
                    DropTarget.this.dispose();
                }
            }
        };
        control.addListener(12, this.controlListener);
        this.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                DropTarget.this.onDispose();
            }
        });
        this.effect = control instanceof Tree ? new TreeDragUnderEffect((Tree)control) : (control instanceof Table ? new TableDragUnderEffect((Table)control) : new NoDragUnderEffect(control));
        this.dragOverHeartbeat = new Runnable(){

            public void run() {
                if (DropTarget.this.control.isDisposed() || DropTarget.this.dragOverStart == 0L) {
                    return;
                }
                long time = System.currentTimeMillis();
                int delay = 50;
                if (time < DropTarget.this.dragOverStart) {
                    delay = (int)(DropTarget.this.dragOverStart - time);
                } else {
                    int allowedOperations = ((DropTarget)DropTarget.this).dragOverEvent.operations;
                    TransferData[] allowedTypes = ((DropTarget)DropTarget.this).dragOverEvent.dataTypes;
                    TransferData[] dataTypes = new TransferData[allowedTypes.length];
                    System.arraycopy(allowedTypes, 0, dataTypes, 0, dataTypes.length);
                    DNDEvent event = new DNDEvent();
                    event.widget = ((DropTarget)DropTarget.this).dragOverEvent.widget;
                    event.x = ((DropTarget)DropTarget.this).dragOverEvent.x;
                    event.y = ((DropTarget)DropTarget.this).dragOverEvent.y;
                    event.time = (int)time;
                    event.feedback = 1;
                    event.dataTypes = dataTypes;
                    event.dataType = DropTarget.this.selectedDataType;
                    event.operations = ((DropTarget)DropTarget.this).dragOverEvent.operations;
                    event.detail = DropTarget.this.selectedOperation;
                    try {
                        DropTarget.this.notifyListeners(2004, event);
                    }
                    catch (Throwable throwable) {
                        event.dataType = null;
                        event.detail = 0;
                    }
                    DropTarget.this.effect.show(event.feedback, event.x, event.y);
                    DropTarget.this.selectedDataType = null;
                    if (event.dataType != null) {
                        int i = 0;
                        while (i < allowedTypes.length) {
                            if (allowedTypes[i].type == event.dataType.type) {
                                DropTarget.this.selectedDataType = event.dataType;
                                break;
                            }
                            ++i;
                        }
                    }
                    DropTarget.this.selectedOperation = 0;
                    if (DropTarget.this.selectedDataType != null && (event.detail & allowedOperations) != 0) {
                        DropTarget.this.selectedOperation = event.detail;
                    }
                }
                DropTarget.this.control.getDisplay().timerExec(delay, DropTarget.this.dragOverHeartbeat);
            }
        };
    }

    static int checkStyle(int style) {
        if (style == 0) {
            return 2;
        }
        return style;
    }

    private static int Drag_Data_Received(int widget, int context, int x, int y, int data, int info, int time) {
        DropTarget target = DropTarget.FindDropTarget(widget);
        if (target == null) {
            return 0;
        }
        target.drag_data_received(widget, context, x, y, data, info, time);
        return 0;
    }

    private static int Drag_Drop(int widget, int context, int x, int y, int time) {
        DropTarget target = DropTarget.FindDropTarget(widget);
        if (target == null) {
            return 0;
        }
        return target.drag_drop(widget, context, x, y, time) ? 1 : 0;
    }

    private static int Drag_Leave(int widget, int context, int time) {
        DropTarget target = DropTarget.FindDropTarget(widget);
        if (target == null) {
            return 0;
        }
        target.drag_leave(widget, context, time);
        return 0;
    }

    private static int Drag_Motion(int widget, int context, int x, int y, int time) {
        DropTarget target = DropTarget.FindDropTarget(widget);
        if (target == null) {
            return 0;
        }
        return target.drag_motion(widget, context, x, y, time) ? 1 : 0;
    }

    private static DropTarget FindDropTarget(int handle) {
        Display display = Display.findDisplay(Thread.currentThread());
        if (display == null || display.isDisposed()) {
            return null;
        }
        Widget widget = display.findWidget(handle);
        if (widget == null) {
            return null;
        }
        return (DropTarget)widget.getData(DROPTARGETID);
    }

    public void addDropListener(DropTargetListener listener) {
        if (listener == null) {
            DND.error(4);
        }
        DNDListener typedListener = new DNDListener(listener);
        this.addListener(2002, typedListener);
        this.addListener(2003, typedListener);
        this.addListener(2004, typedListener);
        this.addListener(2005, typedListener);
        this.addListener(2006, typedListener);
        this.addListener(2007, typedListener);
    }

    protected void checkSubclass() {
        String validName;
        String name = this.getClass().getName();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.dnd.DropTarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!(validName = clazz.getName()).equals(name)) {
            DND.error(43);
        }
    }

    private void drag_data_received(int widget, int context, int x, int y, int data, int info, int time) {
        DNDEvent event = new DNDEvent();
        if (data == 0 || !this.setEventData(context, x, y, time, event)) {
            this.keyOperation = -1;
            return;
        }
        this.keyOperation = -1;
        int allowedOperations = event.operations;
        Object object = null;
        TransferData transferData = new TransferData();
        GtkSelectionData selectionData = new GtkSelectionData();
        OS.memmove((GtkSelectionData)selectionData, (int)data, (int)GtkSelectionData.sizeof);
        if (selectionData.data != 0) {
            transferData.type = selectionData.type;
            transferData.length = selectionData.length;
            transferData.pValue = selectionData.data;
            transferData.format = selectionData.format;
            int i = 0;
            while (i < this.transferAgents.length) {
                if (this.transferAgents[i].isSupportedType(transferData)) {
                    object = this.transferAgents[i].nativeToJava(transferData);
                    break;
                }
                ++i;
            }
        }
        if (object == null) {
            this.selectedOperation = 0;
        }
        event.detail = this.selectedOperation;
        event.dataType = transferData;
        event.data = object;
        try {
            this.notifyListeners(2006, event);
            this.selectedOperation = 0;
            if ((allowedOperations & event.detail) == event.detail) {
                this.selectedOperation = event.detail;
            }
        }
        catch (Throwable throwable) {
            this.selectedOperation = 0;
        }
        OS.gtk_drag_finish((int)context, (this.selectedOperation != 0 ? 1 : 0) != 0, (this.selectedOperation == 2 ? 1 : 0) != 0, (int)time);
    }

    private boolean drag_drop(int widget, int context, int x, int y, int time) {
        DNDEvent event = new DNDEvent();
        if (!this.setEventData(context, x, y, time, event)) {
            this.keyOperation = -1;
            return false;
        }
        this.keyOperation = -1;
        int allowedOperations = event.operations;
        TransferData[] allowedDataTypes = new TransferData[event.dataTypes.length];
        System.arraycopy(event.dataTypes, 0, allowedDataTypes, 0, allowedDataTypes.length);
        event.dataType = this.selectedDataType;
        event.detail = this.selectedOperation;
        try {
            this.notifyListeners(2007, event);
        }
        catch (Throwable throwable) {
            event.detail = 0;
            event.dataType = null;
        }
        this.selectedDataType = null;
        if (event.dataType != null) {
            int i = 0;
            while (i < allowedDataTypes.length) {
                if (allowedDataTypes[i].type == event.dataType.type) {
                    this.selectedDataType = allowedDataTypes[i];
                    break;
                }
                ++i;
            }
        }
        this.selectedOperation = 0;
        if (this.selectedDataType != null && (event.detail & allowedOperations) == event.detail) {
            this.selectedOperation = event.detail;
        }
        if (this.selectedOperation == 0) {
            return false;
        }
        OS.gtk_drag_get_data((int)widget, (int)context, (int)this.selectedDataType.type, (int)time);
        return true;
    }

    private void drag_leave(int widget, int context, int time) {
        this.updateDragOverHover(0L, null);
        this.effect.show(0, 0, 0);
        if (this.keyOperation == -1) {
            return;
        }
        this.keyOperation = -1;
        DNDEvent event = new DNDEvent();
        event.widget = this;
        event.time = time;
        event.detail = 0;
        try {
            this.notifyListeners(2003, event);
        }
        catch (Throwable throwable) {}
    }

    private boolean drag_motion(int widget, int context, int x, int y, int time) {
        DNDEvent event;
        int oldKeyOperation = this.keyOperation;
        if (oldKeyOperation == -1) {
            this.selectedDataType = null;
            this.selectedOperation = 0;
        }
        if (!this.setEventData(context, x, y, time, event = new DNDEvent())) {
            this.keyOperation = -1;
            OS.gdk_drag_status((int)context, (int)0, (int)time);
            return false;
        }
        int allowedOperations = event.operations;
        TransferData[] allowedDataTypes = new TransferData[event.dataTypes.length];
        System.arraycopy(event.dataTypes, 0, allowedDataTypes, 0, allowedDataTypes.length);
        if (oldKeyOperation == -1) {
            event.type = 2002;
        } else if (this.keyOperation == oldKeyOperation) {
            event.type = 2004;
            event.dataType = this.selectedDataType;
            event.detail = this.selectedOperation;
        } else {
            event.type = 2005;
            event.dataType = this.selectedDataType;
        }
        this.updateDragOverHover(50L, event);
        try {
            this.notifyListeners(event.type, event);
        }
        catch (Throwable throwable) {
            OS.gdk_drag_status((int)context, (int)0, (int)time);
            return false;
        }
        if (event.detail == 16) {
            event.detail = (allowedOperations & 2) != 0 ? 2 : 0;
        }
        this.selectedDataType = null;
        if (event.dataType != null) {
            int i = 0;
            while (i < allowedDataTypes.length) {
                if (allowedDataTypes[i].type == event.dataType.type) {
                    this.selectedDataType = allowedDataTypes[i];
                    break;
                }
                ++i;
            }
        }
        this.selectedOperation = 0;
        if (this.selectedDataType != null && (allowedOperations & event.detail) != 0) {
            this.selectedOperation = event.detail;
        }
        this.effect.show(event.feedback, event.x, event.y);
        switch (this.selectedOperation) {
            case 0: {
                OS.gdk_drag_status((int)context, (int)0, (int)time);
                break;
            }
            case 1: {
                OS.gdk_drag_status((int)context, (int)2, (int)time);
                break;
            }
            case 2: {
                OS.gdk_drag_status((int)context, (int)4, (int)time);
                break;
            }
            case 4: {
                OS.gdk_drag_status((int)context, (int)8, (int)time);
            }
        }
        if (oldKeyOperation == -1) {
            this.dragOverHeartbeat.run();
        }
        return true;
    }

    public Control getControl() {
        return this.control;
    }

    private int getOperationFromKeyState() {
        boolean shift;
        int[] state = new int[1];
        OS.gdk_window_get_pointer((int)0, null, null, (int[])state);
        boolean ctrl = (state[0] & 4) != 0;
        boolean bl = shift = (state[0] & 1) != 0;
        if (ctrl && shift) {
            return 4;
        }
        if (ctrl) {
            return 1;
        }
        if (shift) {
            return 2;
        }
        return 16;
    }

    public Transfer[] getTransfer() {
        return this.transferAgents;
    }

    public void notifyListeners(int eventType, Event event) {
        Point pt;
        int x1;
        Rectangle area;
        Point coordinates = new Point(event.x, event.y);
        coordinates = this.control.toControl(coordinates);
        if (this.control instanceof Tree) {
            Tree tree = (Tree)this.control;
            event.item = tree.getItem(coordinates);
            if (event.item == null && (area = tree.getClientArea()).contains(coordinates)) {
                x1 = area.x;
                while (x1 < area.x + area.width) {
                    pt = new Point(x1, coordinates.y);
                    event.item = tree.getItem(pt);
                    if (event.item != null) break;
                    ++x1;
                }
            }
        }
        if (this.control instanceof Table) {
            Table table = (Table)this.control;
            event.item = table.getItem(coordinates);
            if (event.item == null && (area = table.getClientArea()).contains(coordinates)) {
                x1 = area.x;
                while (x1 < area.x + area.width) {
                    pt = new Point(x1, coordinates.y);
                    event.item = table.getItem(pt);
                    if (event.item != null) break;
                    ++x1;
                }
            }
        }
        super.notifyListeners(eventType, event);
    }

    private void onDispose() {
        if (this.control == null) {
            return;
        }
        OS.g_signal_handler_disconnect((int)this.control.handle, (int)this.drag_motion_handler);
        OS.g_signal_handler_disconnect((int)this.control.handle, (int)this.drag_leave_handler);
        OS.g_signal_handler_disconnect((int)this.control.handle, (int)this.drag_data_received_handler);
        OS.g_signal_handler_disconnect((int)this.control.handle, (int)this.drag_drop_handler);
        if (this.transferAgents.length != 0) {
            OS.gtk_drag_dest_unset((int)this.control.handle);
        }
        this.transferAgents = null;
        if (this.controlListener != null) {
            this.control.removeListener(12, this.controlListener);
        }
        this.control.setData(DROPTARGETID, null);
        this.control = null;
        this.controlListener = null;
    }

    private int opToOsOp(int operation) {
        int osOperation = 0;
        if ((operation & 1) == 1) {
            osOperation |= 2;
        }
        if ((operation & 2) == 2) {
            osOperation |= 4;
        }
        if ((operation & 4) == 4) {
            osOperation |= 8;
        }
        return osOperation;
    }

    private int osOpToOp(int osOperation) {
        int operation = 0;
        if ((osOperation & 2) == 2) {
            operation |= 1;
        }
        if ((osOperation & 4) == 4) {
            operation |= 2;
        }
        if ((osOperation & 8) == 8) {
            operation |= 4;
        }
        return operation;
    }

    public void removeDropListener(DropTargetListener listener) {
        if (listener == null) {
            DND.error(4);
        }
        this.removeListener(2002, listener);
        this.removeListener(2003, listener);
        this.removeListener(2004, listener);
        this.removeListener(2005, listener);
        this.removeListener(2006, listener);
        this.removeListener(2007, listener);
    }

    public void setTransfer(Transfer[] transferAgents) {
        if (transferAgents == null) {
            DND.error(4);
        }
        if (this.transferAgents.length != 0) {
            OS.gtk_drag_dest_unset((int)this.control.handle);
        }
        this.transferAgents = transferAgents;
        GtkTargetEntry[] targets = new GtkTargetEntry[]{};
        int i = 0;
        while (i < transferAgents.length) {
            Transfer transfer = transferAgents[i];
            int[] typeIds = transfer.getTypeIds();
            String[] typeNames = transfer.getTypeNames();
            int j = 0;
            while (j < typeIds.length) {
                GtkTargetEntry entry = new GtkTargetEntry();
                byte[] buffer = Converter.wcsToMbcs(null, typeNames[j], true);
                entry.target = OS.g_malloc((int)buffer.length);
                OS.memmove((int)entry.target, (byte[])buffer, (int)buffer.length);
                entry.info = typeIds[j];
                GtkTargetEntry[] newTargets = new GtkTargetEntry[targets.length + 1];
                System.arraycopy(targets, 0, newTargets, 0, targets.length);
                newTargets[targets.length] = entry;
                targets = newTargets;
                ++j;
            }
            ++i;
        }
        int pTargets = OS.g_malloc((int)(targets.length * GtkTargetEntry.sizeof));
        int i2 = 0;
        while (i2 < targets.length) {
            OS.memmove((int)(pTargets + i2 * GtkTargetEntry.sizeof), (GtkTargetEntry)targets[i2], (int)GtkTargetEntry.sizeof);
            ++i2;
        }
        int actions = this.opToOsOp(this.getStyle());
        OS.gtk_drag_dest_set((int)this.control.handle, (int)0, (int)pTargets, (int)targets.length, (int)actions);
        int i3 = 0;
        while (i3 < targets.length) {
            OS.g_free((int)targets[i3].target);
            ++i3;
        }
    }

    private boolean setEventData(int context, int x, int y, int time, DNDEvent event) {
        int operation;
        if (context == 0) {
            return false;
        }
        GdkDragContext dragContext = new GdkDragContext();
        OS.memmove((GdkDragContext)dragContext, (int)context, (int)GdkDragContext.sizeof);
        if (dragContext.targets == 0) {
            return false;
        }
        int style = this.getStyle();
        int operations = this.osOpToOp(dragContext.actions) & style;
        if (operations == 0) {
            return false;
        }
        this.keyOperation = operation = this.getOperationFromKeyState();
        if (operation == 16) {
            if ((style & 0x10) == 0) {
                operation = (operations & 2) != 0 ? 2 : 0;
            }
        } else if ((operation & operations) == 0) {
            operation = 0;
        }
        int length = OS.g_list_length((int)dragContext.targets);
        TransferData[] dataTypes = new TransferData[]{};
        int i = 0;
        while (i < length) {
            int pData = OS.g_list_nth((int)dragContext.targets, (int)i);
            GtkTargetPair gtkTargetPair = new GtkTargetPair();
            OS.memmove((GtkTargetPair)gtkTargetPair, (int)pData, (int)GtkTargetPair.sizeof);
            TransferData data = new TransferData();
            data.type = gtkTargetPair.target;
            int j = 0;
            while (j < this.transferAgents.length) {
                if (this.transferAgents[j].isSupportedType(data)) {
                    TransferData[] newDataTypes = new TransferData[dataTypes.length + 1];
                    System.arraycopy(dataTypes, 0, newDataTypes, 0, dataTypes.length);
                    newDataTypes[dataTypes.length] = data;
                    dataTypes = newDataTypes;
                    break;
                }
                ++j;
            }
            ++i;
        }
        if (dataTypes.length == 0) {
            return false;
        }
        Point coordinates = this.control.toDisplay(new Point(x, y));
        event.widget = this;
        event.x = coordinates.x;
        event.y = coordinates.y;
        event.time = time;
        event.feedback = 1;
        event.dataTypes = dataTypes;
        event.dataType = dataTypes[0];
        event.operations = operations;
        event.detail = operation;
        return true;
    }

    private void updateDragOverHover(long delay, DNDEvent event) {
        if (delay == 0L) {
            this.dragOverStart = 0L;
            this.dragOverEvent = null;
            return;
        }
        this.dragOverStart = System.currentTimeMillis() + delay;
        if (this.dragOverEvent == null) {
            this.dragOverEvent = new DNDEvent();
        }
        this.dragOverEvent.x = event.x;
        this.dragOverEvent.y = event.y;
        TransferData[] dataTypes = new TransferData[event.dataTypes.length];
        System.arraycopy(event.dataTypes, 0, dataTypes, 0, dataTypes.length);
        this.dragOverEvent.dataTypes = dataTypes;
        this.dragOverEvent.operations = event.operations;
    }
}

