/*
   SwingWT
   Copyright(c)2003-2004, R. Rawson-Tetley

   For more information on distributing and using this program, please
   see the accompanying "COPYING" file.

   Contact me by electronic mail: bobintetley@users.sourceforge.net

   $Log: JPanel.java,v $
   Revision 1.28  2004/10/30 20:11:57  bobintetley
   Code cleanup

   Revision 1.27  2004/07/19 13:02:32  dannaab
   Undo manager bug fixes

   Revision 1.26  2004/05/10 14:33:17  bobintetley
   MDI support and JPanel border fixes

   Revision 1.25  2004/05/07 15:42:47  bobintetley
   *** empty log message ***

   Revision 1.24  2004/05/07 12:11:18  bobintetley
   Default layout fixes and correct behaviour for null layout

   Revision 1.23  2004/04/30 23:18:26  dannaab
   List selection support, misc bug fixes

   Revision 1.22  2004/04/30 13:20:43  bobintetley
   Fix to unrealised peer preferred sizes, forwarding window events to
   content panes and fix for mouse drag events.

   Revision 1.21  2004/04/28 08:38:11  bobintetley
   Hierarchy fixes, code cleanup for base classes, additional javadocs and use of flag to identify JComponent descendants with peers

   Revision 1.20  2004/04/27 06:37:44  bobintetley
   Corrected hierarchy with JComponent descending Container

   Revision 1.19  2004/04/23 00:52:32  dannaab
   Handle borders in a Swing-like way. Implement EmptyBorder & TitledBorder

   Revision 1.18  2004/03/30 14:22:27  bobintetley
   Fix to Component min/max sizing code, fix to JPanel insets with titled
   borders (all of which indirectly fix problems with BoxLayout). Addition
   of ComponentAdapter

   Revision 1.17  2004/02/02 12:36:37  bobintetley
   Proper JScrollPane/ScrollBar implementation

   Revision 1.16  2004/01/27 09:05:11  bobintetley
   ListModel and List Selection implemented. ScrollPane fix so all components
      scrollable

   Revision 1.15  2004/01/26 12:02:49  bobintetley
   JPanel titled border support

   Revision 1.14  2004/01/09 14:48:26  bobintetley
   Experiments for titled border

   Revision 1.13  2004/01/05 15:29:37  bobintetley
   TableLayout fixes

   Revision 1.12  2004/01/05 10:09:52  bobintetley
   Various fixes for new layouts

   Revision 1.11  2003/12/22 11:01:42  bobintetley
   JPanel resize hints can be given on the fly

   Revision 1.10  2003/12/17 09:03:14  bobintetley
   Closely matches Swing behaviour + JScrollPane support for Panels

   Revision 1.9  2003/12/16 17:46:17  bobintetley
   Additional thread safety methods

   Revision 1.8  2003/12/15 18:29:57  bobintetley
   Changed setParent() method to setSwingWTParent() to avoid conflicts with applications

   Revision 1.7  2003/12/15 15:54:25  bobintetley
   Additional core methods

   Revision 1.6  2003/12/14 09:13:38  bobintetley
   Added CVS log to source headers

 */


package swingwtx.swing;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;

public class JPanel extends JComponent {

    /** The panel's peer */
    protected Composite ppeer = null;
    protected boolean opaque = true;

    /** Creates a new JPanel */
    public JPanel() {this(false);}
    /** Creates a new JPanel with the specified buffering scheme
     *  @param isDoubleBuffered  Whether or not to double buffer paint callbacks
     */
    public JPanel(boolean isDoubleBuffered) { this(new swingwt.awt.FlowLayout(), false); }
    /** Creates a new JPanel with the specified layout
     *  @param layout The layout manager to use
     */
    public JPanel(swingwt.awt.LayoutManager layout) { setLayout(layout); }
    /** Creates a new JPanel with the specified layout and buffering scheme
     *  @param layout The layout manager to use
     *  @param isDoubleBuffered Whether or not to double buffer paint callbacks
     */
    public JPanel(swingwt.awt.LayoutManager layout, boolean isDoubleBuffered) { setLayout(layout); }
    /** Creates a new JPanel with the specified layout
     *  @param layout The layout manager to use
     */
    public JPanel(swingwt.awt.LayoutManager2 layout) { setLayout(layout); }
    /** Creates a new JPanel with the specified layout and buffering scheme
     *  @param layout The layout manager to use
     *  @param isDoubleBuffered Whether or not to double buffer paint callbacks
     */
    public JPanel(swingwt.awt.LayoutManager2 layout, boolean isDoubleBuffered) { setLayout(layout); }
    /** Overriden to calculate non-realised
     *  preferred size.
     */
    protected swingwt.awt.Dimension calculatePreferredSize() {
        // Default 300x200
        swingwt.awt.Dimension size = new swingwt.awt.Dimension(300, 200);
        setSize(size);
        return size;
    }
    
    /** Callback for when this is added to a Container to create the
     *  peer and load cached values.
     */
    public void setSwingWTParent(swingwt.awt.Container parent) throws Exception {
        descendantHasPeer = true;
        
        boolean usePlatformBorder = 
            (border instanceof swingwtx.swing.border.EtchedBorder) ||
            (border instanceof swingwtx.swing.border.LineBorder) ||
            (border instanceof swingwtx.swing.border.BevelBorder) ||
            (border instanceof swingwtx.swing.border.SoftBevelBorder);
        
        ppeer = new Composite(parent.getComposite(), usePlatformBorder ? SWT.BORDER : SWT.NONE );
        peer = ppeer;
        composite = ppeer;
        this.parent = parent;
        super.setSwingWTParent(parent);
    }

    /** Sets the border for the Panel
     *  @param b The new border
     */
    public void setBorder(swingwtx.swing.border.Border b) {
        border = b;
    }

    /**
     *  Return how large this panel would like to be if it's inside a ScrollPane, rather
     *  than how large it actually is. This is used by layout managers when determining
     *  how to layout the components. If you need the actual size of a JPanel in
     *  a scroll pane, use getPeerSize() which always return the
     *  correct values.
     */
    public swingwt.awt.Dimension getSize() {
        if (parent instanceof JScrollPane)
            return getPreferredSize();
        else
            return super.getSize();
    }
    /** Returns the width of the peer
     *  @return the width
     */
    public int getWidth() { return getSize().width; }
    /** Returns the height of the peer
     *  @return the height
     */
    public int getHeight() { return getSize().height; }

}
