/*
 * Decompiled with CFR 0.152.
 */
package swingwtx.swing;

import java.io.IOException;
import java.net.URL;
import swingwt.awt.Color;
import swingwt.awt.Container;
import swingwt.awt.Dimension;
import swingwtx.swing.SwingWTUtils;
import swingwtx.swing.editorpanes.EditorPane;
import swingwtx.swing.event.HyperlinkListener;
import swingwtx.swing.text.Document;
import swingwtx.swing.text.EditorKit;
import swingwtx.swing.text.JTextComponent;

public class JEditorPane
extends JTextComponent {
    protected EditorPane editorPaneImpl = null;

    public JEditorPane() {
        this.loadBrowserEditorPane();
    }

    public JEditorPane(String url) throws IOException {
        this.loadBrowserEditorPane();
        this.setPage(url);
    }

    public JEditorPane(String type, String text) {
        if (type.equalsIgnoreCase("text/html")) {
            this.loadBrowserEditorPane();
        } else {
            this.loadTextEditorPane();
        }
        this.setText(text);
    }

    public JEditorPane(URL url) throws IOException {
        this.loadBrowserEditorPane();
        this.setPage(url);
    }

    private void loadTextEditorPane() {
        this.loadEditor("swingwtx.swing.editorpanes.TextEditorPane");
    }

    private void loadBrowserEditorPane() {
        if (!this.loadEditor("swingwtx.swing.editorpanes.PlatformBrowserEditorPane")) {
            this.loadEditor("swingwtx.swing.editorpanes.FakeBrowserEditorPane");
        }
    }

    private boolean loadEditor(String clazz) {
        try {
            Class<?> c = Class.forName(clazz);
            this.editorPaneImpl = (EditorPane)c.getConstructors()[0].newInstance(null);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    protected Dimension calculatePreferredSize() {
        Dimension size = new Dimension(300, 200);
        this.setSize(size);
        return size;
    }

    public void setSwingWTParent(Container parent) throws Exception {
        this.descendantHasPeer = true;
        this.editorPaneImpl.setSwingWTParent(parent);
        this.peer = this.editorPaneImpl.getSWTPeer();
    }

    public String getText() {
        return this.editorPaneImpl.getText();
    }

    public void setText(String text) {
        this.editorPaneImpl.setText(text);
    }

    public String getContentType() {
        return this.editorPaneImpl.getContentType();
    }

    public void setContentType(String contentType) {
        this.editorPaneImpl.setContentType(contentType);
    }

    public boolean isEditable() {
        return this.editorPaneImpl.isEditable();
    }

    public void setEditable(boolean b) {
        this.editorPaneImpl.setEditable(b);
    }

    public void setDocument(Document newdoc) {
        this.editorPaneImpl.setDocument(newdoc);
    }

    public Document getDocument() {
        return this.editorPaneImpl.getDocument();
    }

    public void setPage(URL url) throws IOException {
        if (!SwingWTUtils.isSWTControlAvailable(this.editorPaneImpl.getSWTPeer())) {
            this.loadBrowserEditorPane();
        }
        this.editorPaneImpl.setPage(url);
    }

    public void setPage(String url) throws IOException {
        this.setPage(new URL(url));
    }

    public void addHyperlinkListener(HyperlinkListener l) {
        this.editorPaneImpl.addHyperlinkListener(l);
    }

    public void removeHyperlinkListener(HyperlinkListener l) {
        this.editorPaneImpl.removeHyperlinkListener(l);
    }

    public void setCaretPosition(int pos) {
        this.editorPaneImpl.setCaretPosition(pos);
    }

    public int getCaretPosition() {
        return this.editorPaneImpl.getCaretPosition();
    }

    public int getSelectionStart() {
        return this.editorPaneImpl.getSelectionStart();
    }

    public int getSelectionEnd() {
        return this.editorPaneImpl.getSelectionEnd();
    }

    public EditorKit getEditorKit() {
        return this.editorPaneImpl.getEditorKit();
    }

    public void setEditorKit(EditorKit k) {
        this.editorPaneImpl.setEditorKit(k);
    }

    public void setSelectionColor(Color color) {
        this.editorPaneImpl.setSelectionColor(color);
    }

    public Color getSelectionColor() {
        return this.editorPaneImpl.getSelectionColor();
    }
}

