/**
 * \file pixmap.h
 * \brief Swami XPM pixmap images header file
 *
 * Declares included pixmaps and provides a way to fetch them.
 */

/*
 * Swami
 * Copyright (C) 1999-2003 Josh Green <jgreen@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA or point your web browser to http://www.gnu.org.
 *
 * To contact the author of this program:
 * Email: Josh Green <jgreen@users.sourceforge.net>
 * Swami homepage: http://swami.sourceforge.net
 */
#ifndef __PIXMAP_H__
#define __PIXMAP_H__

#include "swamidll.h"

/* new pixmap declarations should be added here */

extern char *folder_xpm[];
extern char *folder_open_xpm[];
extern char *gen_ctrl_xpm[];
extern char *gen_default_xpm[];
extern char *gen_graph_xpm[];
extern char *gen_set_xpm[];
extern char *gen_view_xpm[];
extern char *gzone_xpm[];
extern char *inst_xpm[];
extern char *loaded_xpm[];
extern char *modedit_xpm[];
extern char *mod_junct_xpm[];
extern char *mod_concave_NB_xpm[];
extern char *mod_concave_NU_xpm[];
extern char *mod_concave_PB_xpm[];
extern char *mod_concave_PU_xpm[];
extern char *mod_convex_NB_xpm[];
extern char *mod_convex_NU_xpm[];
extern char *mod_convex_PB_xpm[];
extern char *mod_convex_PU_xpm[];
extern char *mod_linear_NB_xpm[];
extern char *mod_linear_NU_xpm[];
extern char *mod_linear_PB_xpm[];
extern char *mod_linear_PU_xpm[];
extern char *mod_switch_NB_xpm[];
extern char *mod_switch_NU_xpm[];
extern char *mod_switch_PB_xpm[];
extern char *mod_switch_PU_xpm[];
extern char *mute_xpm[];
extern char *piano_xpm[];
extern char *preset_xpm[];
extern char *rom_xpm[];
extern char *sample_xpm[];
extern char *samview_xpm[];
extern char *drivers_off_xpm[];
extern char *drivers_on_xpm[];
extern char *velocity_xpm[];

SWAMI_API void pixmap_get (gchar **xpm_data, GdkPixmap **pixmap,
			   GdkBitmap **mask);

#endif
