#!/bin/sh
set -e
STARTDIR=`pwd`
TMP_ARCHIVE="test@localhost--`date +%s`.$$"
SVN_AM="$STARTDIR/svn-arch-mirror"

cleanup () {
	cd "$STARTDIR"
	rm -rf ,test || true
}

cleanup
mkdir ,test
svnadmin create --fs-type fsfs ,test/repo
gzip -dc test_repo.dump.gz | svnadmin load ,test/repo

mkdir ,test/tree
cd ,test/tree
svn co "file://$STARTDIR/,test/repo/test/trunk" test_co
tla make-archive $TMP_ARCHIVE $PWD/,tmp-archive
cd test_co
export SVN_ARCH_MIRROR_DEBUG=1
$SVN_AM init --strict --sign -A $TMP_ARCHIVE svn-am--test--0

tla register-archive -d "$TMP_ARCHIVE"
cleanup

