###
# Copyright (c) 2002-2004, Jeremiah Fincher
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
#   * Redistributions of source code must retain the above copyright notice,
#     this list of conditions, and the following disclaimer.
#   * Redistributions in binary form must reproduce the above copyright notice,
#     this list of conditions, and the following disclaimer in the
#     documentation and/or other materials provided with the distribution.
#   * Neither the name of the author of this software nor the name of
#     contributors to this software may be used to endorse or promote products
#     derived from this software without specific prior written consent.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
# LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
# CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
# SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
# INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
# CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
# ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
# POSSIBILITY OF SUCH DAMAGE.
###

"""
Allows people behind a relay bot (which uses <nick@network> to relay messages)
to access the bot.
"""

__revision__ = "$Id: FixRelayBot.py,v 1.13 2004/09/20 03:05:29 jamessan Exp $"

import supybot.plugins as plugins

import re
import random

import supybot.irclib as irclib
import supybot.ircmsgs as ircmsgs
import supybot.ircutils as ircutils

class FixRelayBot(irclib.IrcCallback):
    _re = re.compile(r'<([^@]+)@[^>]+>\s+(.*)')
    def inFilter(self, irc, msg):
        if msg.command == 'PRIVMSG':
            m = self._re.match(msg.args[1])
            if m:
                nick = m.group(1)
                host = random.random()*100
                newprefix = ircutils.joinHostmask(nick, nick, host)
                msg = ircmsgs.IrcMsg(command='PRIVMSG', prefix=newprefix,
                                     args=(msg.args[0], m.group(2)))
        return msg


Class = FixRelayBot
# vim:set shiftwidth=4 tabstop=8 expandtab textwidth=78:
