/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.map.proj;

import com.jhlabs.map.proj.PseudoCylindricalProjection;
import java.awt.geom.Point2D;

public class AitoffProjection
extends PseudoCylindricalProjection {
    protected static final int AITOFF = 0;
    protected static final int WINKEL = 1;
    private boolean winkel = false;
    private double cosphi1 = 0.0;

    public AitoffProjection() {
    }

    public AitoffProjection(int type, double projectionLatitude) {
        this.projectionLatitude = projectionLatitude;
        this.winkel = type == 1;
    }

    public Point2D.Double project(double lplam, double lpphi, Point2D.Double out) {
        double c = 0.5 * lplam;
        double d = Math.acos(Math.cos(lpphi) * Math.cos(c));
        if (d != 0.0) {
            out.y = 1.0 / Math.sin(d);
            out.x = 2.0 * d * Math.cos(lpphi) * Math.sin(c) * out.y;
            out.y *= d * Math.sin(lpphi);
        } else {
            out.y = 0.0;
            out.x = 0.0;
        }
        if (this.winkel) {
            out.x = (out.x + lplam * this.cosphi1) * 0.5;
            out.y = (out.y + lpphi) * 0.5;
        }
        return out;
    }

    public void initialize() {
        super.initialize();
        if (this.winkel) {
            this.cosphi1 = 0.6366197723675814;
        }
    }

    public boolean hasInverse() {
        return false;
    }

    public String toString() {
        return this.winkel ? "Winkel Tripel" : "Aitoff";
    }
}

