/*
 *  dixchange_dic.c
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "dixchange.h"
#include "anthy.h"
#include "canna.h"
#include "dixchange_dic.h"

int dixchange_export(const char* filename, int type) {
    GList *list;

    switch(type) {
    case 0: /* Anthy */
	list = anthy_read_privatediclist();
	dixchange_write(list, filename);
	break;
    case 1: /* Canna */
	list = canna_read_privatediclist();
	dixchange_write(list, filename);
	break;
    default:
	break;
    }
    return 0;
}
