/* ====================================================================
 * Copyright (c) 2003-2007, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "config.h"
#include "FontSettingsWidget.h"
#include "sublib/ExternButton.h"

// qt
#include <QtGui/QLayout>
#include <QtGui/QLabel>
#include <QtGui/QLineEdit>
#include <QtGui/QPushButton>
#include <QtGui/QFontDialog>

// sys
#include <assert.h>



FontSettingsWidget::FontSettingsWidget( QWidget *parent )
: super(parent)
{
  QVBoxLayout* vl = new QVBoxLayout(this);
  {
    int row = 0;

    QGridLayout* gl = new QGridLayout(vl,2,3);
    gl->setMargin(2);
    gl->setSpacing(5);
    gl->setColStretch( 0, 5 );
    gl->setColStretch( 1, 1 );
    gl->setColStretch( 2, 1 );
    vl->addStretch(1);
    {
      // general
      QLabel* gLabel = new QLabel(_q("general application font:"), this);
      _gFamily       = new QLineEdit( this );
      _gSize         = new QLineEdit( this );
      QPushButton* gFont = new ExternButton( this );
      _gFamily->setDisabled(true);
      _gSize->setDisabled(true);
      _gFamily->setLineWidth( 1 );
      _gSize->setLineWidth( 1 );
      _gFamily->setMargin( 0 );

      gl->addMultiCellWidget(gLabel,row,row,0,2);
      row++;
      gl->addWidget(_gFamily,row,0);
      gl->addWidget(_gSize,row,1);
      gl->addWidget(gFont,row,2);
      row++;

      // editor
      QLabel* eLabel = new QLabel(_q("source files & merge editor font (usually a fixed width font):"), this);
      _eFamily       = new QLineEdit( this );
      _eSize         = new QLineEdit( this );
      QPushButton* eFont = new ExternButton( this );
      _eFamily->setDisabled(true);
      _eSize->setDisabled(true);
      _eFamily->setLineWidth( 1 );
      _eSize->setLineWidth( 1 );

      gl->addMultiCellWidget(eLabel,row,row,0,2);
      row++;
      gl->addWidget(_eFamily,row,0);
      gl->addWidget(_eSize,row,1);
      gl->addWidget(eFont,row,2);
      row++;

      connect( gFont, SIGNAL(clicked()), SLOT(selectGeneralFont()) );
      connect( eFont, SIGNAL(clicked()), SLOT(selectEditorFont()) );
    }
  }
}

FontSettingsWidget::~FontSettingsWidget()
{
}

void FontSettingsWidget::selectGeneralFont()
{
  bool ok;
  QFont font = QFontDialog::getFont( &ok, _gFont, this );

  if( ok )
  {
    setGeneralFont(font);
    emit modified();
  }
}

void FontSettingsWidget::selectEditorFont()
{
  bool ok;
  QFont font = QFontDialog::getFont( &ok, _eFont, this );

  if( ok )
  {
    setEditorFont(font);
    emit modified();
  }
}

void FontSettingsWidget::setGeneralFont( const QFont& font )
{
  _gFont = font;
  _gFamily->setText( _gFont.family() );
  _gSize->setText( QString("%1").arg(_gFont.pointSize()) );
}

void FontSettingsWidget::setEditorFont( const QFont& font )
{
  _eFont = font;
  _eFamily->setText( _eFont.family() );
  _eSize->setText( QString("%1").arg(_eFont.pointSize()) );
}

const QFont& FontSettingsWidget::getGeneralFont()
{
  return _gFont;
}

const QFont& FontSettingsWidget::getEditorFont()
{
  return _eFont;
}
