/* ====================================================================
 * Copyright (c) 2006,      Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "config.h"
#include "MsgHandler.h"
#include "MessageBox.h"
#include "Utility.h"

// qt
#include <QtGui/QApplication>


static void MessageHandler( QtMsgType type, const char *msg )
{
  switch ( type )
  {
  case QtDebugMsg:
    msgInformation( getLongAppName(), msg, _q("&Ok") );
    break;
  case QtWarningMsg:
    msgWarning( getLongAppName(), msg, _q("&Ok") );
    break;
  case QtFatalMsg:
    msgCritical( getLongAppName(), msg, _q("&Abort") );
    abort();
  }
}

void installMessageHandler()
{
  qInstallMsgHandler(MessageHandler);
}
