/* ====================================================================
 * Copyright (c) 2006,      Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */
  
#ifndef _SC_FILEDATA_H
#define _SC_FILEDATA_H

// boost
#include <boost/shared_ptr.hpp>

// sc
#include "util/types.h"
#include "util/String.h"
#include "util/apr.h"
#include "util/utf.h"
namespace sc {
  class Error;
}

class FileData
{
public:
  FileData( const sc::String& name, const sc::String& encoding );
  ~FileData();

  const sc::Error* read();
  const sc::Error* xlate();
  const sc::Error* xlateBinary();

  const sc::String& getName() const;
  const sc::String& getEncoding() const;

  const unsigned char* getBuffer() const;
  sc::Size getBufferSize() const;

  const Bom& getBom() const;

private:
  FileData( const FileData& );
  const sc::Error* xlate( const char* from, const char* to );

private:
  apr::Pool _pool;

  sc::String _name;
  sc::String _encoding;
  Bom        _bom;

  const unsigned char* _buf;
  sc::Size             _len;

  const unsigned char* _bufXlate;
  sc::Size             _lenXlate;
};

typedef boost::shared_ptr<FileData>  FileDataPtr;

#endif // _SC_FILEDATA_H
