/* ====================================================================
 * Copyright (c) 2006-2008  Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "Path.h"
#include "util/apr.h"

// svn
#include <svn_path.h>

// apr
#include <apr_tables.h>


namespace svn
{
 
  
sc::String Path::findPrefix( const Paths& paths )
{
  apr::Pool pool;

  if( paths.size() == 0 )
  {
    return sc::String();
  }
  else if( paths.size() == 1 )
  {
    char* res = svn_path_dirname( paths.front(), pool );

    return sc::String(res);
  }
  else
  {
    sc::String ancestor = paths.front();

    for( Paths::const_iterator it = paths.begin(); it != paths.end(); it++ )
    {
      ancestor = svn_path_get_longest_ancestor( ancestor, *it, pool );
    }

    return ancestor;
  }
}

sc::String Path::getBaseName( const sc::String& path )
{
  if( path.isEmpty() )
    return sc::NullString;

  apr::Pool pool;
  return sc::String( svn_path_basename(path,pool) );
}

sc::String Path::getDirName( const sc::String& path )
{
  if( path.isEmpty() )
    return sc::NullString;
 
  apr::Pool pool;
  return sc::String( svn_path_dirname(path,pool) );
}

bool Path::isUrl( const sc::String& path )
{
  return svn_path_is_url(path) == TRUE;
}

sc::String Path::getUriDecode( const sc::String& path )
{
  apr::Pool pool;
  return sc::String( svn_path_uri_decode(path,pool) );
}


} // namespace
