/* ====================================================================
 * Copyright (c) 2009       Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#include "TextStatusFilterTest.h"

// cppunit
#include <cppunit/TestSuite.h>
#include <cppunit/TestCaller.h>

// sc
#include "subcommander/TextStatusFilter.h"


void TextStatusFilterTest::setUp()
{
}

void TextStatusFilterTest::tearDown()
{
}

void TextStatusFilterTest::testSingleStatus()
{
  TextStatusFilter filter;

  CPPUNIT_ASSERT_EQUAL( false, filter.test(StatusNone) );
  filter.set(StatusNone);
  CPPUNIT_ASSERT_EQUAL( true, filter.test(StatusNone) );
  filter.clear(StatusNone);
  CPPUNIT_ASSERT_EQUAL( false, filter.test(StatusNone) );
}

void TextStatusFilterTest::testMultipleStatus()
{
  TextStatusFilter filter;

  CPPUNIT_ASSERT_EQUAL( false, filter.test(StatusAdded) );
  CPPUNIT_ASSERT_EQUAL( false, filter.test(StatusModified) );
  filter.set(StatusAdded);
  CPPUNIT_ASSERT_EQUAL( true, filter.test(StatusAdded) );
  filter.set(StatusModified);
  CPPUNIT_ASSERT_EQUAL( true, filter.test(StatusModified) );
  filter.clear(StatusAdded);
  CPPUNIT_ASSERT_EQUAL( false, filter.test(StatusAdded) );
  filter.clear(StatusModified);
  CPPUNIT_ASSERT_EQUAL( false, filter.test(StatusModified) );
}
