/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _DOUBLE_TEXT_WIDGET_H
#define _DOUBLE_TEXT_WIDGET_H

// sc
#include "TextViewWidget.h"
#include "util/String.h"
class TextWidget;
class TextLineNrWidget;
class TextGlueWidget;
class TextModel;
class DiffInfoModel;

// qt
class QLineEdit;
class QCheckBox;
class QVBox;


class DoubleTextWidget : public TextViewWidget
{
  typedef TextViewWidget super;
  Q_OBJECT 

public:
  DoubleTextWidget( QWidget *parent=0, const char *name=0 );
  virtual ~DoubleTextWidget();

  void setModel( TextModel* left, TextModel* right );
  void setModel( DiffInfoModel* info );
  void setLeftLabel( const sc::String& l );
  void setRightLabel( const sc::String& r );

  TextWidget* getLeftText() const;
  TextWidget* getRightText() const;

  void jumpToLine( int line );
  void jumpToBlock( int block );
  void setActiveDiff( int num );

  void setAcceptDrops(bool on);

protected:
  QSize getScrollSizeHint();
  QSize getScrollSizeCurr();

public slots:
  void vsbChange(int);
  void hsbChange(int);
  void xChange(int);
  void yChange(int);
  void toggleLeft(bool);
  void toggleRight(bool);
  void toggleLong(bool);
  void mouseLine(int);

private:
  QCheckBox*         _checkLeft;
  QCheckBox*         _checkRight;
  QCheckBox*         _checkLong;
  QVBox*             _long;

  TextWidget*        _left;
  TextLineNrWidget*  _lLines;
  QLineEdit*         _lLabel;
  TextWidget*        _right;
  TextLineNrWidget*  _rLines;
  QLineEdit*         _rLabel;
  TextGlueWidget*    _glue;

  TextWidget*        _l;
  TextWidget*        _r;
};


#endif // _DOUBLE_TEXT_WIDGET_H

