/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_CLEANUPCMD_H
#define _SC_CLEANUPCMD_H

// sc
#include "ScCmd.h"
class CmdResultCallback;
class CleanupParam;

/**
 * Command for cleaning up a working copy.
 */
class CleanupCmd : public ScCmd
{
public:
  /**
   * Construct a CleanupCmd.
   *
   * \param param the parameters for the command.
   * \param cb the callback that gets called when the command has finished.
   * The command takes ownership the callback.
   */
  CleanupCmd( CleanupParam* param, CmdResultCallback* cb );
  ~CleanupCmd();

  void run();

private:
  // in
  CleanupParam*      _param;

  // out
  CmdResultCallback* _cb;
};

#endif // _SC_CLEANUPCMD_H
