/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_TEXTWINDOW_H
#define _SC_TEXTWINDOW_H

// sc
class TextEdit;
class FontSettings;

// qt
#include <qwidget.h>
class QPushButton;


class TextWindow : public QWidget
{
  typedef QWidget super;
  Q_OBJECT 

public:
  TextWindow( const QString& title, FontSettings* fs, QWidget *parent = 0 );
  virtual ~TextWindow();

  void setText( const QString& text );
  void loadText( const QString& file );

public slots:
  void save();
  void close();

private:
  TextEdit*    _text;

  QPushButton* _save;
  QPushButton* _close;
};

#endif // _SC_TEXTWINDOW_H
