/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "config.h"
#include "RemoveDialog.h"
#include "sublib/Gui.h"
#if 0
#include "WcModel.h"
#include "ScModel.h"
#include "TextEdit.h"
#include "PostCmdResult.h"
#include "NullCmdResult.h"
#include "settings/FontSettings.h"
#include "commands/DiffParam.h"
#include "sublib/SplitLayout.h"
#include "util/String.h"
#endif

// qt
#include <qlayout.h>
#include <qgroupbox.h>
#include <qpushbutton.h>
#include <qlabel.h>
#include <qcombobox.h>
#include <qfiledialog.h>
#include <qtooltip.h>
#include <qcheckbox.h>
#include <qtextedit.h>
#include <qlistview.h>
#include <qvbox.h>



RemoveDialog::RemoveDialog( QWidget *parent, bool force, bool unversioned )
: super( parent, 0, true, Qt::WStyle_Customize | Qt::WStyle_Dialog |
  Qt::WStyle_NormalBorder | Qt::WStyle_Title | Qt::WStyle_SysMenu )
{
  setCaption( _q("subcommander:remove") );

  QVBoxLayout *vbl = new QVBoxLayout(this,5,8);
  vbl->setSpacing(10);
  {
    QGroupBox* gb = new QGroupBox(1,Qt::Vertical,this);
    gb->setTitle( _q("remove options: ") );
    //gb->setInsideSpacing(10);
    gb->setInsideMargin(0);
    gb->setFlat(true);
    vbl->addWidget(gb);

    QHBoxLayout* h1 = new QHBoxLayout;
    vbl->addLayout(h1);
    {
      _force = new QCheckBox(_q("&remove modified"),this);
      _force->setChecked(force);
      h1->addWidget(_force);
    }

    if( unversioned )
    {
      QLabel* l1 = new QLabel(this);
      l1->setText(_q("You have selected unversioned items. You will not be able to restore them."));
      vbl->addWidget(l1);
    }

    QHBoxLayout* hu = new QHBoxLayout;
    vbl->addLayout(hu);
    {
      // eats extra space, so the buttons keep their size
      hu->addStretch(1); 

      _ok = new QPushButton(this);
      _ok->setText( _q("&Remove") );
      _ok->setDefault(true);
      hu->addWidget(_ok);
      QPushButton* ca = new QPushButton(this);
      ca->setText( _q("&Cancel") );
      hu->addWidget(ca);
      
      hu->addSpacing(getSizeGripSpacing());

      connect( _ok, SIGNAL(clicked()), SLOT(accept()) );
      connect( ca, SIGNAL(clicked()), SLOT(reject()) );
    }
  }

  // don't resize vertically.
  setMaximumHeight( sizeHint().height() );
}

RemoveDialog::~RemoveDialog()
{
}
