/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_MERGEDIALOG_H
#define _SC_MERGEDIALOG_H

// sc
class ScModel;
class RevisionWidget;
class MergeParam;
class ExternProvider;
namespace svn
{
  class Revision;
}

// qt
#include <qwidget.h>
class QComboBox;
class QCheckBox;
class QPushButton;
class QLabel;


class MergeDialog : public QWidget
{
  typedef QWidget super;
  Q_OBJECT 

public:
  MergeDialog( ScModel* model, ExternProvider* p, QWidget *parent = 0 );
  virtual ~MergeDialog();

  void closeEvent( QCloseEvent* e );

  void enableRepositoryUrl1( bool enable );
  void enableRepositoryUrl2( bool enable );
  void enableWorkingCopyPath( bool enable );

  void setRepositoryUrl1( const QString& url );
  void setRepositoryUrl2( const QString& url );
  void setWorkingCopyPath( const QString& path );

  void setRevision1( const svn::Revision* );
  void setRevision2( const svn::Revision* );

  MergeParam* getParameters( bool dryrun ) const;

public slots:
  void changedMergeType( bool );
  void selectRep1Url();
  void selectRep2Url();
  void selectWcPath();
  void checkOk( const QString& text );
  void accept();
  void reject();

signals:
  void dryrun();
  void merge();
  void closed();

private slots:
  void xdryrun();

private:
  ExternProvider* _p;

  QLabel*         _rep1L;
  QComboBox*      _rep1;
  QPushButton*    _rep1B;

  QCheckBox*      _type;
  QComboBox*      _rep2;
  QLabel*         _rep2L;
  QPushButton*    _rep2B;

  QComboBox*      _wc;

  RevisionWidget* _rwPeg;
  RevisionWidget* _rw1;
  RevisionWidget* _rw2;

  QCheckBox*      _recurse;
  QCheckBox*      _ancestry;
  QCheckBox*      _force;

  QPushButton*    _ok;
  QPushButton*    _dry;
};

#endif // _SC_MERGEDIALOG_H
