%define		name	stklos
%define		version 0.55
%define		release 1

Name:    	%{name}
Version: 	%{version}
Release: 	%{release}
Summary: 	Scheme Interpreter/Compiler System
Requires:	gmp
Group:		Development/Languages
Source: 	%{name}-%{version}.tar.gz
URL:		http://kaolin.unice.fr/STklos
Copyright: 	GPL
Buildroot: 	/var/tmp/%{name}-root
Provides:	stklos

%description
STklos is a fast Scheme bytecode interpreter trying to conform to R5RS. 
It is the successor of STk (a Scheme interpreter able to access the Tk 
toolkit). 

STklos provides an extensive and efficient Object Oriented extension 
providing multiple inheritance, generic functions, multi-methods. Its
implementation relies on a CLOS-like Meta Object Protocol.

STklos also provides a connection to GTK+ allowing to make GUI in a clean 
and easy way.

%prep 
%setup

%build
CFLAGS="-O3 -fomit-frame-pointer" sh ./configure --prefix=%{_prefix} && make

%install
[ -n "$RPM_BUILD_ROOT" -a "$RPM_BUILD_ROOT" != / ] && rm -rf $RPM_BUILD_ROOT
make install-strip prefix=$RPM_BUILD_ROOT%{_prefix}

%clean
[ -n "$RPM_BUILD_ROOT" -a "$RPM_BUILD_ROOT" != / ] && rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root,0755)
%doc README INSTALL NEWS ChangeLog TODO PACKAGES-USED AUTHORS

%{_prefix}/bin/stklos
%{_prefix}/bin/stklos-config
%{_prefix}/bin/stklos-compile
%{_prefix}/bin/stklos-script
%{_prefix}/share/man/man1/stklos.1.gz
%{_prefix}/share/man/man1/stklos-config.1.gz
%{_prefix}/share/man/man1/stklos-compile.1.gz
%{_prefix}/lib/stklos/%{version}
%{_prefix}/share/stklos/%{version}
%{_prefix}/include/stklos/stklos.h
%{_prefix}/include/stklos/extraconf.h

%changelog

