/*
 * s i o . c					-- Low level I/O
 * 
 * Copyright  1993-2002 Erick Gallesio - I3S-CNRS/ESSI <eg@unice.fr>
 * 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, 
 * USA.
 * 
 * 
 *	     Author: Erick Gallesio [eg@kaolin.unice.fr]
 *    Creation date: ????
 * Last file update: 22-Feb-2002 12:33 (eg)
 *
 *
 * Completely rewritten for the STklos version (Jan. 2000)
 *
 */

#include "stklos.h"

int 
STk_readyp(SCM port)
{
  if (PORT_UNGETC(port) != EOF) return 1;
  return PORT_READY(port)(PORT_STREAM(port));
}


int 
STk_getc(SCM port)
{
  int result = PORT_UNGETC(port);

  if (result != EOF) {
    /* There was an ungetted char */
    PORT_UNGETC(port) = EOF;
    return result;
  }
  /* No ungetted char; read ahead */
  result = PORT_GETC(port)(PORT_STREAM(port));
  PORT_POS(port) += 1;
  if (result == '\n') PORT_LINE(port) +=1;

  return result;
}

int 
STk_ungetc(int c, SCM port)
{
  int result = PORT_UNGETC(port);
  
  if (result != EOF) STk_error("INTERNAL ERROR: cannot unget character");
  PORT_UNGETC(port) = c;
  PORT_POS(port)   -= 1;
  if ((char) c == '\n') PORT_LINE(port) -= 1;

  return c;
}

int 
STk_close(SCM port)
{
#ifdef STK_PORT_FINALIZER
  STk_register_finalizer(port, NULL); /* Unregister (possible) finalizer */
#endif
  PORT_RELEASE(port)(port);

  PORT_FLAGS(port) |= PORT_CLOSED;
  return PORT_CLOSE(port)(PORT_STREAM(port));
}

int 
STk_putc(int c, SCM port)
{
  return PORT_PUTC(port)(c, PORT_STREAM(port));
}

int
STk_puts(char *s, SCM port)
{
  return PORT_PUTS(port)(s, PORT_STREAM(port));
}

int
STk_flush(SCM port)
{
  return PORT_FLUSH(port)(PORT_STREAM(port));
}

int 
STk_feof(SCM port)
{
  return PORT_EOFP(port)(PORT_STREAM(port));
}

int
STk_read_buffer(SCM port, void *buff, int count)
{
  return PORT_BREAD(port)(PORT_STREAM(port), buff, count);
}

int
STk_write_buffer(SCM port, void *buff, int count)
{
  return PORT_BWRITE(port)(PORT_STREAM(port), buff, count);
}


int 
STk_fprintf(SCM port, char *format, ...)
{
  va_list ap;
  char buffer[PORT_MAX_PRINTF];

  va_start(ap, format);
  vsprintf(buffer, format, ap);
  return STk_puts(buffer, port);
}
