## Script (Python) "validate"
##title=Validate Postings
##parameters=raw=None

if raw is None:
    # being called from previewPosting
    raw = context.REQUEST
    posting = context.dummyPosting()
else:
    posting = context
    
Processed = {}

# get the encoding and specify a site default
encoding = raw.get('encoding','HTML')
Processed['encoding']=encoding

# get fields and make their html safe
for field in posting.getFields():
    value = raw.get(field,None)
    if value is not None:
        if encoding!='Plain':
            value = context.html2safehtml(value)
        Processed[field]=value

# stick notify in processed
Processed['notify']=raw.get('notify','')

# integrity checks
if raw.get('notify') and not raw.get('email'):
    return Processed,'You must enter an email address for notification!'

if   posting.meta_type=='Article':
    
    if not raw.get('title') or \
       not raw.get('author') or \
       not raw.get('subject') or \
       not raw.get('summary'):
        
        return Processed,'You must enter a title, author, subject and summary!'

elif posting.meta_type=='Comment':
    
    if not raw.get('title') or \
       not raw.get('author') or \
       not raw.get('body'):

        return Processed,'You must enter a title, author and body!'

return Processed,None
