# Copyright (c) 2001 Chris Withers
#
# This Software is released under the MIT License:
# http://www.opensource.org/licenses/mit-license.html
# See license.txt for more details.
#
# $Id: __init__.py,v 1.3 2001/08/17 15:05:15 fresh Exp $

__version__="1.0"

from html2text import HTML2Text
from html2safehtml import HTML2SafeHTML

def html2text(s):
    parser = HTML2Text()
    parser.feed(s)
    parser.close()
    return parser.result

def html2safehtml(s, valid_tags=('b', 'a', 'i', 'br', 'p')):
    parser = HTML2SafeHTML(valid_tags)
    parser.feed(s)
    parser.close()
    parser.cleanup()
    return parser.result
