/*
	Copyright (c) 2008 Robin Vobruba <hoijui.quaero@gmail.com>

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "CppTestAI.h"


#include "ExternalAI/Interface/AISEvents.h"
#include "ExternalAI/Interface/AISCommands.h"

// generated by the C++ Wrapper scripts
#include "AI/Wrappers/Cpp/src-generated/OOAICallback.h"
#include "AI/Wrappers/Cpp/src-generated/SkirmishAI.h"
#include "AI/Wrappers/Cpp/src-generated/Unit.h"
#include "AI/Wrappers/Cpp/src-generated/UnitDef.h"
#include "AI/Wrappers/Cpp/src-generated/Engine.h"
#include "AI/Wrappers/Cpp/src-generated/WrappUnit.h"

#include <string>

cpptestai::CCppTestAI::CCppTestAI(springai::OOAICallback* callback):
		callback(callback),
		skirmishAIId(callback != NULL ? callback->GetSkirmishAIId() : -1),
		game(NULL)
		{
			game = new CSpringGame(callback);
		}

cpptestai::CCppTestAI::~CCppTestAI() {}

int cpptestai::CCppTestAI::HandleEvent(int topic, const void* data) {

	switch (topic) {
		case EVENT_INIT: {
			game->Me()->Init();
			break;
		}
		case EVENT_RELEASE: {
			game->Me()->GameEnd();
			break;
		}
		case EVENT_UPDATE: {
			game->Me()->Update();
			break;
		}
		case EVENT_UNIT_GIVEN: {
			struct SUnitGivenEvent* evt = (struct SUnitGivenEvent*) data;
			if(evt->unitId < 0){
				game->SendToConsole("shard-runtime warning: unitgiven evt->unit < 0");
				break;
			}
			// it might not have been given to us! Could have been given to another team
			springai::Unit* unit = springai::WrappUnit::GetInstance(skirmishAIId, evt->unitId);
			if(callback->GetSkirmishAI()->GetTeamId() == unit->GetTeam()){
				CSpringUnit* u = new CSpringUnit(callback,unit,game);
				aliveUnits[evt->unitId] = u;
				game->Me()->UnitGiven(u);
			}
			break;
		}
		case EVENT_UNIT_CREATED: {
			struct SUnitCreatedEvent* evt = (struct SUnitCreatedEvent*) data;
			if(evt->unit < 0){
				game->SendToConsole("shard-runtime warning: unitcreated evt->unit < 0");
				break;
			}
			springai::Unit* unit = springai::WrappUnit::GetInstance(skirmishAIId, evt->unit);
			if(unit != NULL){
				CSpringUnit* u = new CSpringUnit(callback,unit,game);
				aliveUnits[evt->unit] = u;
				game->Me()->UnitCreated(u);
			}
			break;
		}
		case EVENT_UNIT_FINISHED: {
			struct SUnitFinishedEvent* evt = (struct SUnitFinishedEvent*) data;
			if(evt->unit < 0){
				game->SendToConsole("shard-runtime warning: unitfinished evt->unit < 0");
				break;
			}
			CSpringUnit* u = 0;
			if(aliveUnits.find(evt->unit) != aliveUnits.end()){
				 u = aliveUnits[evt->unit];
			}
			if( u == 0){
				springai::Unit* unit = springai::WrappUnit::GetInstance(skirmishAIId, evt->unit);
				if(unit != NULL){
					u = new CSpringUnit(callback,unit,game);
					aliveUnits[evt->unit] = u;
				}
			}
			if(u != 0){
				game->Me()->UnitBuilt(u);
			}
			break;
		}
		case EVENT_UNIT_DESTROYED: {
			struct SUnitDestroyedEvent* evt = (struct SUnitDestroyedEvent*) data;
			if(evt->unit < 0){
				game->SendToConsole("shard-runtime warning: unitdestroyed evt->unit < 0");
				break;
			}
			std::map<int, CSpringUnit* >::iterator i = aliveUnits.find(evt->unit);
			if(i != aliveUnits.end()){
				CSpringUnit* u = i->second;
				game->Me()->UnitDead(u);
				aliveUnits.erase(i);
				delete u;
			}
			break;
		}
		case EVENT_UNIT_DAMAGED: {
			struct SUnitDamagedEvent* evt = (struct SUnitDamagedEvent*) data;
			if(evt->unit < 0){
				game->SendToConsole("shard-runtime warning: unitdamaged evt->unit < 0");
				break;
			}
			CSpringUnit* u = 0;
			if (aliveUnits.find(evt->unit) != aliveUnits.end()){
				u = aliveUnits[evt->unit];
			}
			CSpringUnit* a = 0;
			if (aliveUnits.find(evt->attacker) != aliveUnits.end()){
				a = aliveUnits[evt->attacker];
			}
			game->Me()->UnitDamaged(u,a);
			break;
		}
		case EVENT_UNIT_IDLE: {
			struct SUnitIdleEvent* evt = (struct SUnitIdleEvent*) data;
			if(evt->unit < 0){
				game->SendToConsole("shard-runtime warning: unitidle evt->unit < 0");
				break;
			}
			CSpringUnit* u = aliveUnits[evt->unit];
			game->Me()->UnitIdle(u);
			break;
		}
		default: {
			break;
		}
	}

	// signal: everything went OK
	return 0;
}
