#!/usr/local/bin/perl

use SmallPigVars qw($config);
use SmallPig;

use SPDB;
use SPCGI;

use Templates::Default;

use strict;

my $lang;

sub main{
# print "Content-type: text/html\n\n";      

  # --- create a SPDB object
  my $spdb = SPDB->new();
  
  my $spcgi = SPCGI->new($spdb);
  $spcgi->set_state_for_client();
  
  my $STATE = $spcgi->{'STATE'};
  my $dpage = $STATE->{'dpage'};

  $lang = SmallPig::get_lang_ptr($STATE->{'lang'}, "default");

  my $template;
  if($dpage){
      # --- create a template object
      $template = Templates::Default->new($spcgi, $spdb);
  }
  else{
      require Templates::Caution;
      # --- create a template object
      $template = 
	Templates::Caution->new($spcgi, $spdb, "", 
				$lang->{'cant_found_page'}, 
				"$config->{'cgidir'}/index.cgi");
  }
  $template->print_http_header();
  $template->print_template();
}

main();
