package Templates::Preview;

use SmallPigVars qw($config);
use Templates::CommentsNC;

use strict;
use vars qw(@ISA $template);

@ISA = qw(Templates::CommentsNC);

my $lang;

sub new{
  my ($class, $spcgi, $spdb, $fid, $caution) = @_;

  $template = Templates::CommentsNC->new($spcgi, $spdb);

  $template->{'STATE'} = $spcgi->{'STATE'};
  $template->{'spdb'} = $spdb || SPDB->new;
  
  $template->{'caution'} = $caution;
  $template->{'fid'} = $fid;
  
  bless $template, $class;

  $template->initialize();
  
  return $template;
}

#########################################################################
# --- Sun Dec 19 23:06:10 PST 1999
# ---
sub initialize{
  my ($template) = @_;

  my $pagefiles = {};
  $pagefiles->{'default'} = "default.temp";
  
  $template->{'pagefiles'} = $pagefiles;

  my $pagesubs = {};
  $pagesubs->{'default'} = \&whole;
  
  $template->{'pagesubs'} = $pagesubs;
  
  $lang = $template->{'lang'};
}

#########################################################################
# --- pagesubs
# ---
sub whole{
  my $STATE = $template->{'STATE'};
  my $fid = $template->{'fid'};
  my ($display, $userstatus, 
      $sid, $cid, $uid, $body, $html, $markup, $prev_op,
      , $fids) = 
      map { $STATE->{$_} } 
  qw(display userstatus 
     sid cid uid body html markup prev_op
     fids);

  # --- set files info
  $fid .= "#" if $fid && $fids;
  my $fids = $template->{'fids'} = $fid.$fids;
  $template->_set_files_info($fids);

  print qq|<FORM METHOD="post" ACTION="$config->{'cgidir'}/comments.cgi" ENCTYPE="multipart/form-data">|;

  $template->print_standard_index();
  
  # --- if caution
  if($template->{'caution'}){
      $template->print_caution_msg("", $template->{'caution'});
      $template->print_space();
  }

  $template->print_preview($fids); 
  $template->print_space();
  $template->print_new_comment_form();
  $template->print_file_att();
  $template->print_bottom_bar();
  
  $prev_op .= "#" if $prev_op;
  print qq|<INPUT type="hidden" name="prev_op" value="$prev_op|."preview\">";

  print qq|<INPUT type="hidden" name="sid" value="$sid">|;

  print qq|<INPUT type="hidden" name="fids" value="$fids">|;

  print qq|<INPUT type="hidden" name="cid" value="$cid">|;
  print qq|<INPUT type="hidden" name="uid" value="$uid">|;
  print qq|<INPUT type="hidden" name="html" value="$html">|;
  print qq|<INPUT type="hidden" name="markup" value="$markup">|;
  
  print "</form>";
}

sub print_preview{
  my ($template, $fids) = @_;
  my ($STATE, $spdb) = map{ $template->{$_} } qw(STATE spdb);
  my $theme = $template->{'theme'};
  
  my ($subject, $bodytext, $name, $email, $sid, $uid, $sig) = 
      map{ $STATE->{$_} } 
  qw(subject body poster posteremail sid uid sig);  

  $subject = $template->filter_html($subject);

  my $user_info;
  
  if($uid == 0){
      $user_info = ($name)?"$name(anon)":"anon"; 
  }
  else{
      $user_info = $name;
  }
  
  my $parent = $lang->{'parent'};
  
  my $reply = $lang->{'reply_post'};

  my $edit_post = "$lang->{'edit_post'}";

  # --- filter html and add <BR>
  my ($html, $markup) = $template->allow_html_markup($sid);
  $bodytext = $template->recover_quote($bodytext);
  $bodytext = $template->filter_html($bodytext) unless $html;
  $bodytext .= "\n\n$sig";
  $bodytext = $template->add_br($bodytext);
  $bodytext = $template->format_markup($bodytext) if $markup;

  my $time = $spdb->db_date("$config->{date_format}");

  my ($files);
  if($fids){
      my $where = join(" OR fid= ", split "#", $fids);       
      $where = "fid=$where";
				      
      ($files) = $spdb->db_select_many_new(1, "fname, fsize, fdesc, date", 
					   "FileAttach", $where);
  }

  my $files_info;

  if($files){
      
      while (my ($fname, $fsize, $fdesc, $date) = $files->fetchrow_array){
	  $date =~ s/\s+/-/g;
	  my $fnameurl;
	  ($fnameurl = $fname) =~ s/(\s+|\\)/-/g;
	  my $fnameurl = qq|<a href="$config->{'file_url'}/$date-$fnameurl">$fname</a>|;
	  $files_info .= "$fnameurl $fsize $lang->{'bytes'} $fdesc<BR>";
      }

      $spdb->db_handler_done($files);
  }

  $spdb->db_handler_done($files);

  $files_info = 
      "<HR align=left width=\"30%\"><B>$lang->{'file_attach2'}:</B><BR>$files_info" if $files_info;

  my $width;
  $width = $theme->{'intblwidth'};

  $template->print_block_start("","","",$width);

  my $content = qq^
      <tr bgcolor="$theme->{'dhdrcolor'}">
	  <td class=bheader1nb>
	      \&nbsp <b>$lang->{'subject'}:</b> $subject 
	  </td>
     </tr>
     <tr bgcolor="$theme->{'lhdrcolor'}">
	 <td class=bheader1nb>
	     &nbsp; &nbsp; $lang->{'posted_by'}: $user_info $lang->{'on'} $time &nbsp; &nbsp; &nbsp; &nbsp; [ $reply | $edit_post | $parent ]
	 </td>
     </tr>
     <tr>
	 <td>
	     <table border=0 cellspacing=0 cellpadding=10 width="100%" bgcolor=$theme->{'boxbgcolor'}>
		 <tr>
		     <td align="left" valign="top">
			 $bodytext<BR>$files_info
		     </td>
		 </tr>
	     </table>
	</td>
     </tr>
	 
	 </td>
	     </tr>
	 ^;
  print "<!--comment-->$content";

  $template->print_block_end();
}

sub print_bottom_bar{
  my ($self) = @_;
  my ($buttons, $ret);

  $buttons = qq|<INPUT TYPE="submit" name="op" value=$lang->{'Submit'}><INPUT TYPE="submit" name="op" value=$lang->{'Preview'}><INPUT TYPE="submit" name="op" value=$lang->{'AttachFile'}>|;

  $template->SUPER::print_block_start();  
  print qq|<tr width="100%"><td><FONT SIZE="1">$buttons</FONT></td></tr>|;
  $template->SUPER::print_block_end();
}

return 1;



