package Templates::NewComment;

use SmallPigVars qw($config);
use Templates::CommentsNC;

use strict;
use vars qw(@ISA $template);

@ISA = qw(Templates::CommentsNC);

my $lang;

sub new{
  my ($class, $spcgi, $spdb, $fid, $caution) = @_;

  $template = Templates::CommentsNC->new($spcgi, $spdb);

  $template->{'STATE'} = $spcgi->{'STATE'};
  $template->{'spdb'} = $spdb || SPDB->new;
  
  $template->{'caution'} = $caution;
  $template->{'fid'} = $fid;
  
  bless $template, $class;

  $template->initialize();
  
  return $template;
}

#########################################################################
# --- Sun Dec 19 23:06:10 PST 1999
# ---
sub initialize{
  my ($template) = @_;
  my $STATE = $template->{'STATE'};

  my $pagefiles = {};
  $pagefiles->{'default'} = "default.temp";
  
  $template->{'pagefiles'} = $pagefiles;

  my $pagesubs = {};
  $pagesubs->{'default'} = \&whole;
  
  $template->{'pagesubs'} = $pagesubs;

  if($STATE->{'op'} eq "reply"){
      my $cid = $STATE->{'cid'};
      my ($tsubject, $tbodytext, $thits, $tip, $tdate, $tclosed, $tsid, $tuid,
	  $tname, $temail, $tpid, $tlastmod, $treplies) = 
	      $template->_select_comment($cid);
      $template->{'rcid'} = $cid;
      $template->{'rsubject'} = $tsubject;
      $template->{'rbody'} = $tbodytext;
      $template->{'rdate'} = $tdate;
      $template->{'rname'} = $tname;
  }

  $lang = $template->{'lang'};
}

#########################################################################
# --- pagesubs
# ---
sub whole{
  my $STATE = $template->{'STATE'};
  my ($fid, $rbody, $rname, $rdate, $spdb) = map { $template->{$_} } 
  qw(fid rbody rname rdate spdb);

  my ($display, $userstatus, 
      $sid, $cid, $uid, $body, $html, $markup, $prev_op,
      $fids, $op) = 
      map { $STATE->{$_} } 
  qw(display userstatus 
     sid cid uid body html markup prev_op
     fids op);

  # --- set files info
  $fid .= "#" if $fid && $fids;
  my $fids = $template->{'fids'} = $fid.$fids;
  
  # --- editpost, need to grab the info from the db
  if($op eq "editpost"){
      my ($fids1) = $spdb->db_select_many_new(1, "fid", "FileAttach", 
					      "cid=$cid");
      $fids = "";
      if($fids1){
	  while (my $fid = $fids1->fetchrow_array){
	      $fids .= "$fid\#";
	  }
      
	  $spdb->db_handler_done($fids1);

	  $fids =~ s/\#$//;

      }
  }

  $template->_set_files_info($fids);

  print qq|<FORM METHOD="post" ACTION="$config->{'cgidir'}/comments.cgi" ENCTYPE="multipart/form-data">|;

  $template->print_standard_index();
  
  # --- if caution
  if($template->{'caution'}){
      $template->print_caution_msg("", $template->{'caution'});
      $template->print_space();
  }

  $template->print_new_comment_form();
  $template->print_file_att();
  $template->print_bottom_bar();
  
  print qq|<INPUT type="hidden" name="sid" value="$sid">|;
  print qq|<INPUT type="hidden" name="fids" value="$fids">|;
  print qq|<INPUT type="hidden" name="cid" value="$cid">|;
  print qq|<INPUT type="hidden" name="uid" value="$uid">|;
  print qq|<INPUT type="hidden" name="html" value="$html">|;
  print qq|<INPUT type="hidden" name="markup" value="$markup">|;

  # --- reply
  if($op =~ /reply/ || $prev_op =~ /reply/){
      $rbody =~ s/((.*\n)|(.+))/&gt;$1/gi;
      my $bodyquote = qq|At $rdate, $rname wrote:\n$rbody|;
      $bodyquote = $template->filter_html($bodyquote);
      print qq|<INPUT TYPE="hidden" NAME="hide" VALUE="$bodyquote">|;
      print qq|<INPUT type="hidden" name="prev_op" value="reply">|;
  }
  elsif($op =~ /editpost/ || $prev_op =~ /editpost/){
      print qq|<INPUT type="hidden" name="prev_op" value="editpost">|;
  }
  else{
      print qq|<INPUT type="hidden" name="prev_op" value="newcomment">|;
  }
  
  print "</form>";
}

sub print_bottom_bar{
  my ($self) = @_;
  my $op = $self->{'STATE'}->{'op'};
  my ($buttons, $ret);

  if($config->{'skip_preview'} eq "yes"){
      $buttons = qq|<INPUT TYPE="submit" name="op" value=$lang->{'Submit'}>|;
  }

  $buttons .= qq|<INPUT TYPE="submit" name="op" value=$lang->{'Preview'}><INPUT TYPE="submit" name="op" value=$lang->{'AttachFile'}>|;

  # --- reply
  if($op eq "reply"){
      $buttons .= qq|<INPUT type="button" name="quote" value="Quote Text" onClick="this.form.body.value=this.form.hide.value + this.form.body.value;">|;
  }

  $template->SUPER::print_block_start();  
  print qq|<tr width="100%"><td><font size="1">$buttons</font></td></tr>|;
  $template->SUPER::print_block_end();
}

return 1;



