package Templates::Admin::StandardIndex;

use SmallPigVars qw($config);
use Templates::Admin::SmallPig;

use strict;
use vars qw(@ISA);

@ISA = qw(Templates::Admin::OptBlock);

my $lang;

sub new{
  my ($class, $STATE) = @_;
  my $content = _get_index($STATE);

  my $theme = $STATE->{'theme'};

  $lang = $STATE->{'langptr'};

  my $classvars = {('content' => $content,
		    'bdrcolor' => $theme->{'inbgcolor'},
		    'bgcolor' => $theme->{'inbgcolor'})};

  my $self = Templates::Admin::OptBlock->new($classvars, $theme);
  return bless $self, $class;
}

sub get{
  my $self = shift;
  $self->SUPER::get();
}

sub _get_index{
  my ($STATE) = @_;
  my ($username, $uid, $pid, $sid, $cid, $view, $op, $userstatus,
      $page, $postsper, $sort, $display) = 
    map { $STATE->{$_} } 
  qw(username uid pid sid cid view op userstatus page postsper sort
     display);
 
  $lang = $STATE->{'langptr'};

  $view = ($view eq "expanded")?"collapsed":"expanded";
  
  # admin
  my $retr = "";
  $retr = "<TR><TD ALIGN=center valign=middle>";
  $retr .= " <A HREF=$config->{'cgidir'}/admin.cgi>$lang->{'admin1'}</A> |" 
    if($userstatus eq "admin");
  $retr .= " <A HREF=$config->{'cgidir'}/admin.cgi>$lang->{'mod1'}</A> |" 
    if($userstatus =~ /mod/);

  $retr .= " <A HREF=$config->{'cgidir'}/index.cgi>$lang->{'forum_index'}</A> |  ";

  # --- encode sid
  $sid = Templates::Admin::SmallPig::url_encode($sid);
  $retr .= "<A HREF=$config->{'cgidir'}/search.cgi?sid=$sid>$lang->{'search'}</A>";
  
  # user is login
  if($userstatus ne "anon" && $uid){
      $retr .= " | <A HREF=$config->{'cgidir'}/user.cgi?page=1&postsper=$postsper>$lang->{'profile'}</A> | 
      <A HREF=$config->{'cgidir'}/user.cgi?op=logout>$lang->{'logout'}</A>";
  }
  else{
      $retr .= " | <A HREF=$config->{'cgidir'}/user.cgi?op=login>
      $lang->{'login'}</A>";
  }

  $retr .= "</TD></TR>";

  return $retr;  
}

return 1;
