package SmallPigVars;

require Exporter;
@ISA = qw(Exporter);
@EXPORT = qw(@EXPORT_OK &get_config);
@EXPORT_OK = qw($config);

use strict;
use vars qw($config);

$config = 
{  
  # --- spmail location: if you dont have spmail installed, 
  # --- comments out the variable below.
  'spmail_cgi'          => "/usr/www/users/smallpig/cgi-bin/sporum/spmail",
    
  'version'             => "1.8b1",
  
  # --- --- url address
  # --- cgi url: the location where the cgi files are placed
  'cgidir'              => "http://smallpig.net/cgi-sys/cgiwrap/smallpig/sporum",
  # --- site url: the url of your site
  'basewwwdir'          => "http://smallpig.net",
  # --- html url
  'htmldir'             => "http://smallpig.net/sporum",
  # --- themes path
  'themesdir'           => "/usr/www/users/smallpig/cgi-bin/sporum/Themes",
  # --- lang module path
  'langsdir'            => "/usr/www/users/smallpig/cgi-bin/sporum/Langs",
  
  # --- --- SQL database 
  # --- name of the remote host on which the DB is running
  'dbhost'              => "",
  # --- port of the remote host
  'dbport'              => "",
  # --- name of the DBI driver
  'dbdriver'            => "mysql",
  # --- name of the DB name
  'dbname'              => "sporum",
  # --- name of the user who use this DB
  'dbuser'              => "smallpig",
  # --- password of the user
  'dbpass'              => "",
  
  # --- --- contact information 
  # -- email address: your email address
  'adminaddr'           => "smallpig\@smallpig.net",
  # --- homepage url: your homepage link
  'adminhp'             => "http://smallpig.net/sporum",
  
  # --- --- email function
  # --- two options to send mail: 
  # --- 1. using sendmail 
  # --- 2. using smtp server
  # --- make sure you uncomment the one you want to use.
  # --- DONT uncomment both...
  # --- sendmail location: the location of the sendmail program 
  # --- in your server
   'sendmail'            => "/usr/sbin/sendmail",
  # --- if you dont have sendmail in your server, set 'smtpserver'
  # --- you are going to use
#  'smtpserver'          => "uclink.berkeley.edu",

  # --- --- file attachment
  # --- allowed file size, 
  'file_size'           => 100000,
  # --- file path: the location the files will store
  'file_path'           => "/usr/www/users/smallpig/sporum/uploaded",
  # --- file url: url location of uploaded files
  'file_url'            => "http://smallpig.net/sporum/uploaded",
  # --- maximum amount of files allowed attached
  'file_max'            => 3,
  
  # --- --- general information  
  # --- name of your forum
  'title'               => "Sporum Demo",
  # --- description of your forum
  'description'         => "Sporum Demo",
  
  # --- --- display operation
  # --- default display mode
  # --- * Threaded -- "threaded"
  # --- * Flat     -- "flat"
  # --- * Nested   -- "nested",
  # --- * Combined -- "combined"
  'display'             => "threaded",
  # --- defautl view mode
  # --- * Collapsed -- "collapsed"
  # --- * Expanded  -- "Expanded"
  'view'                => "collapsed",
  # --- default sort and order of messages
  # --- * descending subject -- "subject desc"
  # --- * ascending subject  -- "subject asc"
  # --- * descending date    -- "date desc"
  # --- * ascending date     -- "date asc"
  # --- * descending name    -- "name desc"
  # --- * ascending name     -- "name asc"
  'sort'                => "date desc",
  # --- maximum number of topics listed in one page
 'postsper'            => 10,
  
  # --- --- registration options
  # --- email duplicate check: check user email is unique or not
  'emaildup'            => "no",
  # --- notify all the admins after registration
  'notifyadmins'        => "yes",
  
  'cookieexpires'       => "+1M",
  'cookiesecret'        => "ynaffit ky 390",
  
  # --- --- others
  # --- subject with $sublen length that shown in topicslist
  'sublen'              => 36,

  # --- Fri Oct 29 23:51:06 PDT 1999
  # --- date format
  'date_format'         => "m/d/y h:i p",
  # --- confirmation option: need to confirm the email address
  # --- after registration
  'confirm_email'       => "no",
  
  # --- Mon Nov  8 00:57:42 PST 1999
  # --- display the message "no forums" if the category is empty
  'display_no_forums'   => "no",

  # --- Sat Nov 20 23:35:39 PST 1999
  # --- chararcter set
  # 'charset'             => "big5",

  # --- allow user to register with self-chose password
  'self_chose_passwd'   => "yes",

  # --- Thu Jan  6 23:15:14 PST 2000
  # --- skip the preview and send the message directly
  'skip_preview'        => "yes",

  # --- Wed Jan 12 20:31:53 PST 2000
  # --- only allow user to have one handler
  'one_hdlr'            => "no",

  # --- Sat Jan 15 10:46:11 PST 2000
  # --- default theme
  'theme'               => "default",

  # --- Sun Jan 23 13:24:11 PST 2000
  # --- default lang
  'lang'                => "default",

  # --- Fri Jan 28 12:01:22 PST 2000
  # --- Applying the following variables let you setup multiple
  # --- copies of sporum using the same database.  If you would 
  # --- like those copies share the same user related tables, 
  # --- simply comment out the 'user_tbl'
  'user_tbl'             => "",
  'rest_tbl'             => "",

  # --- caution refresh
  'refresh'              => 5
  
};

sub get_config{
    return $config;
}
