package Ops::Subscribe;

use SmallPigVars qw($config);
use SmallPig;
use SPDB;

my $lang;

my %sconfig =
    (
     sporum_email => "sporum\@localhost"
     );

sub new{
  my ($class, $STATE) = @_;
  my $self = {};

  $self->{'spdb'} = SPDB->new();
  $self->{'STATE'} = $STATE;
  $self->{'config'} = \%sconfig;
  $self->{'sporum_email'} =  $self->{'config'}->{'sporum_email'};

  $lang = SmallPig::get_lang_ptr($STATE->{lang}, "LSub");

  return bless $self, $class;
}

sub DESTROY{
    my $self = shift;
    my $spdb = $self->{'spdb'};
    $spdb->db_disconnect($spdb->{'dbh'});
}

sub user_subscribe{
  my ($self) = @_;
  my ($STATE, $spdb) = map{ $self->{$_} } qw(STATE spdb); 
  my $DBH = $spdb->{'dbh'};

  my ($sid, $uid) = map{ $self->{STATE}->{$_} } qw(selectedforums uid);

  my @sids = split(/\#/, $sid);
  
  foreach (@sids){
      my $sid = $_;

      $STATE->{sid} = $sid;
      
      if(!$self->can_access($STATE)){
	  return (0, $lang->{'cannot_read'}, "", 
		  $ENV{SCRIPT_NAME}."?op=subscription");
      }

      my $sidq = $DBH->quote($sid);
      if($spdb->db_count("SubscribeBoard", "sid=$sidq")>0){
	  return (0, $lang->{'forum_sub2'});
      }

      my $time = $spdb->db_date();
      my $data = {('sid'=>$sid, 'uid'=>$uid, 'date'=>$time)};
      my ($succ, $errmsg) = $spdb->db_insert("SubscribeBoard", $data);
      # --- if insert fails 
      return (0, $errmsg, "", $ENV{SCRIPT_NAME}."?op=subscription") if !$succ;      
  }
  
  return (1, $lang->{'forum_sub2'}, $lang->{'forum_sub1'}, 
	  $ENV{SCRIPT_NAME}."?op=subscription");
}

sub user_unsubscribe{
  my ($self) = @_;
  my ($STATE, $spdb) = map{ $self->{$_} } qw(STATE spdb);
  my $DBH = $spdb->{'dbh'};
  
  my ($sid, $uid) = map{ $STATE->{$_} } qw(sid uid);  

  if(!$sid || !$uid){
    return (0, $lang->{'cant_found_page'}, "", 
	    $ENV{SCRIPT_NAME}."?op=subscription");
  }
  
  if($sid eq "*"){
      $spdb->db_delete("SubscribeBoard", "uid=$uid");
  }
  else{
      my $sidq = $DBH->quote($sid);
      $spdb->db_delete("SubscribeBoard", "sid=$sidq AND uid=$uid");
  }
  return (1, $lang->{'forum_unsub2'}, $lang->{'forum_unsub1'},
	  $ENV{SCRIPT_NAME}."?op=subscription");
}

sub save_subscription{
  my ($self) = @_;
  my ($STATE, $spdb) = map{ $self->{$_} } qw(STATE spdb);
  my $DBH = $spdb->{'dbh'}; 

  my ($sid, $uid, $eformat) = 
    map{ $STATE->{$_} } qw(sid uid seformat);
  my $sidq = $DBH->quote($sid);

  if(!$sid || !$uid){
    return (0, $lang->{'cant_found_page'}, "", 
	    $ENV{SCRIPT_NAME}."?op=subscription");
  }
  my ($succ, $errmsg) = $spdb->db_update("SubscribeBoard", {('eformat'=>$eformat)},
					 "sid=$sidq AND uid=$uid");
  return (0, $errmsg, "", 
	    $ENV{SCRIPT_NAME}."?op=subscription") if(!$succ);
  return (1, $lang->{'save_sub2'}, $lang->{'save_sub1'}, 
	  $ENV{SCRIPT_NAME}."?op=subscription");
}

sub _sporum_subscription{
  my ($self, $sid, $content, $type) = @_;
  my ($STATE, $spdb) = map{ $self->{$_} } qw(STATE spdb);
  my $DBH = $spdb->{'dbh'}; 

  $content = SmallPig::recover_markup($content);

  my $sidq = $DBH->quote($sid);
  my ($title) = $spdb->db_select_cols("title", "Boards", "sid=$sidq");
  my $ret = qq|-------------------------------------------
Message from $config->{'title'} forum:
$title
Your subscription is set to $type
-------------------------------------------

$content
|;
  return $ret;
}

sub send_individual_msg{
  my ($self, $cid) = @_;
  my ($STATE, $spdb) = map{ $self->{$_} } qw(STATE spdb);
  my $DBH = $spdb->{'dbh'}; 

  my ($subject, $bodytext, $hits, $ip, $time, $closed, $sid, $uid,
      $name, $email, $pid, $lastmod, $replies) = 
	$self->select_comment($cid);

  $email ||= $name;
  
  my $sidq = $DBH->quote($sid);
  my ($users) = $spdb->db_select_many_new(1, "realemail",
					  "SubscribeBoard AS SB,
                                      Users AS U",
					  "SB.uid=U.uid AND eformat=4 
                                      AND U.active=1 AND sid=$sidq");
  my ($title) = $spdb->db_select_cols("title", "Boards", "sid=$sidq");
  my $body = $self->_sporum_subscription($sid, $bodytext, "individual messages"); 
  $subject = "[$title] $subject ($cid)";
  
  if($users){

      while (my ($realemail) = $users->fetchrow_array){
	SmallPig::send_mail($realemail, $email, $subject, $body, $self->{'sporum_email'}) if $realemail;
      }

      $spdb->db_handler_done($users);
      
  }
}

sub _subscription_msg{
  my ($subject, $author, $email, $date, $content) = @_;

  $content = SmallPig::recover_markup($content);

  $email = "<$email>" if $email;
  my $ret = qq|Subject: $subject
Author: $author $email
Date: $date  

$content
|;
  return $ret;
}

sub send_daily_digest{
  my ($self) = @_;
  my ($STATE, $spdb) = map{ $self->{$_} } qw(STATE spdb);
  my $DBH = $spdb->{'dbh'}; 

  my ($sids) = $spdb->db_select_many_new(1, "sid", "Boards");

  if($sids){
      
      while (my ($sid) = $sids->fetchrow_array){
	  my $sidq = $DBH->quote($sid);
	  my ($cids) =
	      $spdb->db_select_many_new(1, "cid", "Posts",
					"TO_DAYS(NOW()) - TO_DAYS(date)<=1
                            AND sid=$sidq", "ORDER BY date");
	  my $msgs;
	  if($cids){
	      while ( my ($cid) = $cids->fetchrow_array){
		  my ($subject, $bodytext, $hits, $ip, $time, $closed, $sid, 
		      $uid, $name, $email, $pid, $lastmod, $replies) = 
			  $self->select_comment($cid);
		  
		  $bodytext =~ s/<BR>/\n/gi;
		  $msgs .= "\n-------------------------------------------------\n";
		  $msgs .= _subscription_msg($subject, $name, $email, $time, $bodytext);
		  $msgs .= "\n-------------------------------------------------\n";
	      }
	      my $body = $self->_sporum_subscription($sid, $msgs, "daily digest"); 
	
	      my ($users) = $spdb->db_select_many_new(1, "realemail",
						      "SubscribeBoard AS SB,
                                        Users AS U",
						      "SB.uid=U.uid AND eformat=1
                                        AND U.active=1 AND sid=$sidq");

	      if($users){

		  while (my ($realemail) = $users->fetchrow_array){
		    SmallPig::send_mail($realemail, $config->{'adminaddr'},
					"$config->{'title'} Daily Digest", $body) if $realemail;
		  }

		  $spdb->db_handler_done($users);
		  
	      }

	      $spdb->db_handler_done($cids);

	  }
      }

      $spdb->db_handler_done($sids);

  }
}

sub send_daily_summary{
  my ($self) = @_;
  my ($STATE, $spdb) = map{ $self->{$_} } qw(STATE spdb);
  my $DBH = $spdb->{'dbh'}; 
  
  my ($sids) = $spdb->db_select_many_new(1, "sid", "Boards");

  if($sids){

      while (my ($sid) = $sids->fetchrow_array){
	  my $sidq = $DBH->quote($sid);
	  my ($cids) =
	      $spdb->db_select_many_new(1, "cid", "Posts",
					"TO_DAYS(NOW()) - TO_DAYS(date)<=1
                            AND sid=$sidq", "ORDER BY date");
	  my $msgs;
	  if($cids){
	      while ( my ($cid) = $cids->fetchrow_array){
		  my ($subject, $bodytext, $hits, $ip, $time, $closed, $sid, 
		      $uid, $name, $email, $pid, $lastmod, $replies) = 
			  $self->select_comment($cid);
		  $sid = SmallPig::url_encode($sid);
		  $msgs .= "* $config->{'cgidir'}/comments.cgi?op=threadlist&sid=$sid&cid=$cid&display=threaded\n";
		  $msgs .= _subscription_msg($subject, $name, $email, $time);
	      }
	      
	      my $body = $self->_sporum_subscription($sid, $msgs, "daily summary"); 
	      
	      my ($users) = $spdb->db_select_many_new(1, "realemail",
						  "SubscribeBoard AS SB,
                                        Users AS U",
						      "SB.uid=U.uid AND eformat=2
                                        AND U.active=1 AND sid=$sidq");

	      if($users){
		  
		  while (my ($realemail) = $users->fetchrow_array){
		    SmallPig::send_mail($realemail, $config->{'adminaddr'},
					"$config->{'title'} Daily Summary", $body) if $realemail;
		  }

		  $spdb->db_handler_done($users);
		  
	      }

	      $spdb->db_handler_done($cids);
	      
	  }
      }
      
      $spdb->db_handler_done($sids);

  }
}
  
sub _uid_from_email{
    my ($self, $email) = @_;
    my ($STATE, $spdb) = map{ $self->{$_} } qw(STATE spdb);
    my $DBH = $spdb->{'dbh'}; 

    my $emailq = $DBH->quote($email);
    my ($uid) = $spdb->db_select_cols("uid", "Users", "realemail=$emailq");

    return $uid;
}

sub _sid_from_cid{
    my ($self, $cid) = @_;
    my ($STATE, $spdb) = map{ $self->{$_} } qw(STATE spdb);
    my $DBH = $spdb->{'dbh'};
    
    my ($sid) = $spdb->db_select_cols("sid", "Posts", "cid=$cid");

    return $sid;
}

sub select_comment{
  my ($self, $cid) = @_;
  my $spdb = $self->{'spdb'};
  
  my ($subject, $bodytext, $hits, $ip, $time,  
      $closed, $sid, $uid) = 
        $spdb->db_select_cols("subject, bodytext, hits, ip, 
                          date_format(date, \"$config->{date_format}\"),
                          closed, sid, uid",
                             "Posts", "cid=$cid");
  my ($name, $email, $privlev);
  if($uid != 0){
      ($name, $email, $privlev) = 
          $spdb->db_select_cols("nickname, fakeemail, privlev",
                                "Users", "uid=$uid");
  }
  else{
      ($name, $email) = 
          $spdb->db_select_cols("anon, email", "AnonPosts", "cid=$cid");
  }
  my ($pid) = $spdb->db_select_cols("parentid", "ParentAndChild", 
                                   "childid=$cid");
  
  my $mpid = $self->select_the_most_parent($cid);
  my ($lastmod, $replies) =
    $spdb->db_select_cols("date_format(lastmod, \"$config->{date_format}\"),
                          replies",
                         "MostParents",
                         "cid=$mpid");

  # --- lang support
  $time =~ s/(jan|feb|mar|apr|may|jun|jul|aug|sep|oct|nov|dec)/$lang->{$1}/ig;
  $lastmod =~ s/(jan|feb|mar|apr|may|jun|jul|aug|sep|oct|nov|dec)/$lang->{$1}/ig;

  return ($subject, $bodytext, $hits, $ip, $time, $closed, $sid, $uid,
          $name, $email, $pid, $lastmod, $replies, $privlev);
}

sub select_the_most_parent{
  my ($self, $cid) = @_;
  my $spdb = $self->{'spdb'};
  
  # --- find out its parentid
  my ($pid) = $spdb->db_select_cols("parentid", "ParentAndChild",
                                   "childid=$cid");
  if(!$pid){
    return $cid;
  }
  else{
      $self->select_the_most_parent($pid);
  }
}

sub can_access{
  my ($self, $mail) = @_;
  my ($spdb) = map{ $self->{$_} } qw(spdb);
  my $DBH = $spdb->{'dbh'};

  my ($sid, $username, $uid) = 
      map{ $mail->{$_} } qw(sid username uid);

  return 0 unless $sid;

  my ($user_status, $tuserstatus) = $self->check_user_status($mail);
  $mail->{userstatus} = $user_status;
  $mail->{tuserstatus} = $tuserstatus;

  my $sidq = $DBH->quote($sid);
  my ($level, $active);
  ($level, $active) = $spdb->db_select_cols("level, active", "Boards", 
					    "sid=$sidq");
  return 0 if(($user_status ne "admin" && $user_status ne "mod") &&
	      $active==0);
  my $status = $self->get_board_status($level);

  #print "*** can_access: $sid, $username, $uid, $user_status, $status\n";
  
  # --- sid from mod userstatus --> ptr to arr
  my $sfmus = $tuserstatus->{mod};
  my $sfgmus = $tuserstatus->{gmem};

  foreach (@$sfmus){
      #print "** mod * $_\n";
  }
  foreach (@$sfgmus){
      #print "** gmem * $_\n";
  }
  
  return 1 if($user_status eq "admin" || 
	      ($sfmus && grep { $_ eq $sid } @$sfmus) || 
	      ($sfgmus && grep { $_ eq $sid } @$sfgmus) ||
	      (($user_status =~ /gmem/ || $user_status eq "ruser" ||
		$user_status =~ /mod/) && $status !~ /group private/) || 
	       ($user_status eq "anon" && $status =~ /public/));
  return 0;
}

sub get_board_status{
    my ($self, $level) = @_;
  my $status = "public" unless 63^$level;
  $status = "public protected" unless 62^$level;
  $status = "user public" unless 60^$level;
  $status = "user private" unless 56^$level;
  $status = "user private protected" unless 48^$level;
  $status = "group private" unless 32^$level;
  return $status;
}

# return "anon"  - anonymous
#        "ruser  - registered user
#        "mod"   - moderator
#        "admin" - administration
#        "gmem"  - group member
sub check_user_status{
  my ($self, $mail) = @_;
  my ($spdb) = map{ $self->{$_} } qw(spdb);
  my $DBH = $spdb->{'dbh'};

  my ($sid, $uid, $username) = 
    map{ $mail->{$_} } qw(sid uid username);
  
  return "anon" if($username eq "anon");

  my $sidq = $DBH->quote($sid);
  my $usernameq = $DBH->quote($username);

  my $where = "username=$usernameq";
  
  # --- if user is admin?
  my ($isadmin) = $spdb->db_select_cols("isadmin", "Users", 
					$where);
  return "admin" if $isadmin;

  my ($userstatus, %tuserstatus);
  $where = "uid=$uid ";
  #$where .= "AND sid=$sidq" if($sid);
  # --- if user is mod?
  my ($sids) = $spdb->db_select_many_new(1, "sid", "Moderators", $where);
  if($sids){
    $userstatus = "mod|||";
    while (my ($sid) = $sids->fetchrow_array){
	$userstatus .= "$sid|||";
	push @{$tuserstatus{mod}}, $sid;
    }

    $spdb->db_handler_done($sids);

  }
  $userstatus =~ s/(.+)\|\|\|$/$1/;
  # --- if user is gmem?
  ($sids) = $spdb->db_select_many_new(1, "sid", "GroupMems", $where);
  if($sids){
      $userstatus .= "###gmem|||";
      while (my ($sid) = $sids->fetchrow_array){
	  $userstatus .= "$sid|||";
	  push @{$tuserstatus{gmem}}, $sid;
      }
      
      $spdb->db_handler_done($sids);

  }
  $userstatus =~ s/(.+)\|\|\|$/$1/;
  $userstatus ||= "ruser";
  return ($userstatus, \%tuserstatus);
}

return 1;






