package Ops::Comments;

use SmallPigVars qw($config);
use SmallPig;

use CGI qw(:standard :cgi-lib);
use CGI::Cookie ();

use strict;

my $lang;

sub new{
  my ($class, $STATE, $spdb) = @_;
  my $self = {};

  # --- create a caution obj
  if($spdb){ $self->{'spdb'} = $spdb; }
  else{  require SPDB; $self->{'spdb'} = SPDB->new; }

  $self->{'STATE'} = {};
  $self->{'STATE'} = $STATE;

  $lang = SmallPig::get_lang_ptr($STATE->{lang}, "LComments");

  return bless $self, $class;
}

sub DESTROY{
    my $self = shift;
    my $spdb = $self->{'spdb'};
    $spdb->db_disconnect($spdb->{'dbh'});
}

sub mark_all_threads{
  my ($self) = @_;
    my ($STATE, $spdb) = map{ $self->{$_} } qw(STATE spdb);
  my $DBH = $spdb->{'dbh'};
  my $nps = $STATE->{'nps'};

  my ($sid) = map{ $STATE->{$_} } qw(sid);
  my $uri = "$config->{'cgidir'}/comments.cgi?op=topicslist&sid=$sid";
  if(defined($sid)){
      my @nps = split(/\,/, $nps);
      
      # --- make sure the posts are in database
      my ($cnt, $where);
      foreach (@nps){
	  $where .= "cid=$_ OR ";
      }
      $where =~ s/OR $//;
      my ($cids);
      if ($where){
	  my $sidq = $DBH->quote($sid);
	  $where = "($where) AND sid=$sidq";
	  ($cids) = $spdb->db_select_many_new(1, "cid", "Posts", $where) if $where;
      }
      
      if($cids){

	  while (my $tcid = $cids->fetchrow_array){
	      my $cid = "$tcid,";
	      if($nps =~ /(.*)$cid(.*)/){
		  # --- erase the cid
		  $nps = "$1$2";
	      }   
	  }
	  
	  $spdb->db_handler_done($cids);

      }
  }
  else{
      $nps = "";
      $uri = "$config->{'cgidir'}/index.cgi";
  }

  $STATE->{'nps'} = $nps;

  # --- encode sid
  $sid = SmallPig::url_encode($sid);

  return (1, $lang->{'mark_all_threads2'}, $lang->{'mark_all_threads1'}, $uri);  
}

sub get_submit_post{
  my ($self) = @_;
  # --- get the caution obj
  my ($STATE, $spdb) = map{ $self->{$_} } qw(STATE spdb);
  my $DBH = $spdb->{'dbh'};

  my ($username, $nickname, $fakeemail, $subject, $body, $ip,
      $sid, $uid, $sig, $html, $markup, $fids, $emailreply,
      $userstatus, $poster, $posteremail);
  
  ($username, $nickname, $fakeemail, $subject, $body, $ip,
      $sid, $uid, $sig, $html, $markup, $fids, $emailreply,
      $userstatus, $poster, $posteremail) = 
	map{ $STATE->{$_} } 
  qw(username nickname fakeemail subject 
     body ip sid uid sig html markup fids emailreply userstatus
     poster posteremail);
  
  # --- if there is no subject or body
  if(length($subject)==0 || length($body)==0){
      return (0, $lang->{'form_not_fill_out'});
  }
  
  # --- filter html tag
  $body .= "\n\n$sig" if $sig;
  $body = SmallPig::recover_html($body);

  my $sidq = $DBH->quote($sid);
  my ($approved) = $spdb->db_select_cols("approved", "Boards",
					"sid=$sidq");
  $approved = !$approved;

  # --- lock the table Posts
  $spdb->db_lock(("Posts"));

  my ($mcid) = $spdb->db_select_cols("MAX(cid)", "Posts"); 
  $mcid++;

  $emailreply = ($emailreply eq "yes")?1:0;
  
  # --- get the current time
  my $time = $spdb->db_date();
  my $data = {('cid'=>$mcid,
	       'sid'=>$sid, 
	       'uid'=>$uid,
	       'subject'=>$subject,
	       'bodytext'=>$body,
	       'ip'=>$ip,
	       'approved'=>$approved,
	       'emailreply'=>$emailreply,
	       'date'=>$time)};
  # --- insert post to Posts
  my ($succ, $errmsg) = $spdb->db_insert("Posts", $data);

  # --- unlock the table Posts
  $spdb->db_unlock();

  # insert post to MostParents
  $data = {('sid'=>$sid, 'cid'=>$mcid, 'lastmod'=>$time)};
  $spdb->db_insert("MostParents", $data);

  # --- if Boards is approved to post comment
  my $bmesg = $lang->{'post_entered2'};
  if($approved){
      # --- update Boards
      my $timeq = $DBH->quote($time);
      $data = {('commentcount'=>'commentcount+1', 
		'lastmod'=>$timeq)};
      $spdb->db_update("Boards", $data, "sid=".$DBH->quote($sid));

      # --- send msg to user who subscribe to this board
      require Ops::Subscribe;
    Ops::Subscribe->new->send_individual_msg($mcid);
  }
  else{
      $bmesg = $lang->{'post_entered3'};

      # --- send mail to the moderator
#      require Ops::SubAdmin;
#    Ops::SubAdmin->new($STATE)->send_approve_post_request($mcid);
  }

  # --- update FileAttach
  if($fids){
      $data = {('cid'=>$mcid, 'sid'=>$sidq)};
      my @fids = split(/\#/, $fids);
      my $where;
      foreach (@fids){
	  $where .= "fid=$_ OR ";
      }
      $where =~ s/(.+) OR $/$1/;
      $spdb->db_update("FileAttach", $data, $where);
  }

  # --- update AnonPosts if user is anon
  if($uid == 0 && ($poster || $posteremail)){
      $poster = $posteremail if(!$poster);
      $data = {('cid'=>$mcid, 'sid'=>$sid, 
		'anon'=>$poster, 'email'=>$posteremail)};
      $spdb->db_insert("AnonPosts", $data);
  }
  
  # --- done!
  # --- encode sid
  $sid = SmallPig::url_encode($sid);
  my $uri = "$config->{'cgidir'}/comments.cgi?op=topicslist&sid=$sid";

  return (1, $bmesg, $lang->{'post_entered1'}, $uri);
}

sub get_edit_post{
  my ($self) = @_;
  # --- get the caution obj
  my ($STATE, $spdb);
  ($STATE, $spdb) = map{ $self->{$_} } qw(STATE spdb);
  my $DBH = $spdb->{'dbh'}; 

  my ($username, $nickname, $fakeemail, $subject, $body, $ip,
      $sid, $pid, $cid, $uid, $sig, $html, $markup,
      $fids, $emailreply, $userstatus, $poster, $posteremail);
  ($username, $nickname, $fakeemail, $subject, $body, $ip,
   $sid, $pid, $cid, $uid, $sig, $html, $markup,
   $fids, $emailreply, $userstatus, $poster, $posteremail) = 
       map{ $STATE->{$_} } qw(username nickname fakeemail subject 
			      body ip sid pid cid uid sig 
			      html markup fids emailreply);

  # --- if there is no subject or body
  if(length($subject)==0 || length($body)==0){
      return (0, $lang->{'form_not_fill_out'});
  }

  # ---  filter html tag and then add <BR> tag...
  $body = SmallPig::recover_html($body);
  
  my $sidq = $DBH->quote($sid);
  my ($approved) = $spdb->db_select_cols("approved", "Boards",
					"sid=$sidq");
  my $approved1 = ($approved==1)?0:1;
  
  my $time = $spdb->db_date();
  my ($subjectq, $bodyq, $ipq, $nicknameq, $fakeemailq, $timeq,
      $pidq, $approvedq) =
    map{ $DBH->quote($_) }
  ($subject, $body, $ip, $nickname, $fakeemail, $time, $pid, $approved1);

  $emailreply = ($emailreply eq "yes")?1:0;
  
  my ($isapproved) = $spdb->db_select_cols("approved", 
					   "Posts",
					   "cid=$cid");
#  print "$approvedq, $cid, $sid, $approved";
  # --- update Comments
  my $data = {('subject'=>$subjectq,
	       'bodytext'=>$bodyq,
	       'ip'=>$ipq,
	       'approved'=>$approvedq,
	       'emailreply'=>$emailreply)};

  $spdb->db_update("Posts", $data, "cid=$cid");
  
  # --- update FileAttach
  if($fids){
      $data = {('cid'=>$cid, 'sid'=>$sidq)};
      my @fids = split(/\#/, $fids);
      my $where;
      foreach (@fids){
	  $where .= "fid=$_ OR ";
      }
      $where =~ s/(.+) OR $/$1/;
      $spdb->db_update("FileAttach", $data, $where);
  }

  # --- update Boards
  my $bmesg = $lang->{'post_edited3'};
  if($approved && $isapproved){

      my $cnt = $spdb->db_count("Posts", "sid=$sidq AND approved=1");

      $data = {('commentcount'=>$cnt,
		'lastmod'=>$timeq)};

      # --- send mail to the moderator
#      require Ops::SubAdmin;
#    Ops::SubAdmin->new($STATE)->send_approve_post_request($cid);
  }
  else{

      $data = {('lastmod'=>$timeq)};
      $bmesg = $lang->{'post_entered2'};

  }
  $spdb->db_update("Boards", $data, "sid=$sidq");
  
  # --- update the most parent if approval is needed
  my $mpid = $self->_select_the_most_parent($cid);
  my ($scid, $scnt) = $self->select_the_least_child($mpid);
  
#  if($cid != $mpid){
      my $data;
      if($approved){
	  $data = {('replies'=>$scnt,
		    'lastmod'=>$timeq)};
      }
      else{
	  $data = {('lastmod'=>$timeq)};
      }
      my ($succ, $err_msg) = $spdb->db_update("MostParents", $data, "cid=$mpid");
#  }

  # --- done!
  # --- encode sid
  $sid = SmallPig::url_encode($sid);
  my $uri = "$config->{'cgidir'}/comments.cgi?op=topicslist&sid=$sid";

  return (1, $bmesg, $lang->{'post_edited1'}, $uri);
}

sub get_submit_reply{
  my ($self) = @_;
  # --- get the caution obj
  my ($STATE, $spdb) = map{ $self->{$_} } qw(STATE spdb);
  my $DBH = $spdb->{'dbh'};

  my ($username, $nickname, $fakeemail, $subject, $body, $ip,
      $sid, $uid, $cid, $sig, $html, $markup, $fids, $emailreply,
      $poster, $posteremail);
  ($username, $nickname, $fakeemail, $subject, $body, $ip,
      $sid, $uid, $cid, $sig, $html, $markup, $fids, $emailreply,
      $poster, $posteremail) = 
	map{ $STATE->{$_} } 
  qw(username nickname fakeemail subject body ip sid uid 
     cid sig html markup fids emailreply poster posteremail);

  my $replybody = $body;
  if(length($subject)==0 || length($body)==0){
      return (0, $lang->{'form_not_fill_out'});
  }

  
  $body .= "\n\n$sig" if $sig;
  $body = SmallPig::recover_html($body);

  # --- determine the cid for this reply

  # --- lock the table Posts
  $spdb->db_lock(("Posts", "Boards"));

  my $mcid = $spdb->db_max("cid", "Posts");
  $mcid = 0 unless $mcid; $mcid++;

  # --- if the thread need to be approved by moderator
  my $sidq = $DBH->quote($sid);
  my ($approved, $boardname)
      = $spdb->db_select_cols("approved, title", "Boards", "sid=$sidq");
  my $approved1 = !$approved;

  $emailreply = ($emailreply eq "yes")?1:0;

  # --- get the current time
  my $time = $spdb->db_date();
  my $data = {('cid'=>$mcid,
	       'sid'=>$sid,
	       'uid'=>$uid,
	       'pid'=>$cid,
	       'subject'=>$subject,
	       'date'=>$time,
	       'bodytext'=>$body,
	       'ip'=>$ip,
	       'approved'=>$approved1,
	       'emailreply'=>$emailreply)};
  # --- insert the reply
  $spdb->db_insert("Posts", $data);

  $spdb->db_unlock();

  # --- insert post to ParentAndChild
  $data = {('parentid'=>$cid, 'childid'=>$mcid)};
  $spdb->db_insert("ParentAndChild", $data);

  # --- update FileAttach
  if($fids){
       $data = {('cid'=>$mcid, 'sid'=>$sidq)};
       my @fids = split(/\#/, $fids);
       my $where;
       foreach (@fids){
	   $where .= "fid=$_ OR ";
       }
       $where =~ s/(.+) OR $/$1/;
       $spdb->db_update("FileAttach", $data, $where);
  }
  
  my ($mpid, $children); # --- most parentid and its children
  # --- get the cid of the most parent
  $mpid = $self->_select_the_most_parent($cid);
  my $bmesg = $lang->{'post_entered2'};
  if(!$approved){

      # --- update board, increase the no of comments in board
      $data = {('commentcount'=>'commentcount+1',
		'lastmod'=>$DBH->quote($time))};
      $spdb->db_update("Boards", $data, "sid=$sidq");
      
      # --- update the most parent
      $spdb->db_update("MostParents", 
		       {('replies'=>'replies+1',
			 'lastmod'=>$DBH->quote($time))},
		       "cid=$mpid");
      
      # --- send msg to user who subscribe this board
      require Ops::Subscribe;
    Ops::Subscribe->new->send_individual_msg($mcid);
  }  
  else{
      $bmesg = $lang->{'post_entered3'};

      # --- send mail to the moderator
    #  require Ops::SubAdmin;
    #Ops::SubAdmin->new($STATE)->send_approve_post_request($mcid);
  }

  # --- update AnonPosts if user is anon
  if($uid == 0 && ($poster || $posteremail)){
      $poster = $posteremail if(!$poster);
      $data = {('cid'=>$mcid, 'sid'=>$sid,
		'anon'=>$poster, 'email'=>$posteremail)};
      $spdb->db_insert("AnonPosts", $data);
  }

  # --- finally, we need to notify the user by email
  $children = [];
  $self->_select_children($mpid, $children);
  unshift @$children, $mpid;

  $fakeemail = "<$fakeemail>" if length($fakeemail) > 0;
  foreach (@$children){
    my $cid = $_;
    my ($name, $email, $subject1) = 
      $spdb->db_select_cols("nickname, realemail, subject", 
			   "Posts AS P, Users AS U", 
			   "cid=$cid AND emailreply=1 AND
                            P.uid=U.uid AND U.uid<>0 AND 
                            U.active=1 AND cid<>$mcid");
    if(!$name || !$email || !$subject1){ next; }
    # --- body of the email
    my $mail = qq|A reply has been posted to the following message:

Forum: $boardname
Message: $subject1
Date: $time
From: $nickname  $fakeemail

$replybody
  |;

    SmallPig::send_mail($email, $config->{'adminaddr'},
			$subject, $mail);
  }

  # --- done!
  # --- encode sid
  $sid = SmallPig::url_encode($sid);
  my $uri = "$config->{'cgidir'}/comments.cgi?op=topicslist&sid=$sid";

  return (1, $bmesg, $lang->{'post_entered1'}, $uri);
}

sub _file_encode{
  my ($self, $words) = @_;
  $words =~ s/([^a-zA-Z0-9_.-])/sprintf("%1X", ord($1))/eg;
  return $words;
   
}

sub add_msg_fav{
    my ($self) = @_;
    # --- get the caution obj
    my ($STATE, $spdb) = map{ $self->{$_} } qw(STATE spdb);
    my $DBH = $spdb->{'dbh'};

    my $mconfig = SmallPig::get_spmail_config();
    my ($uid, $cid, $sid, $view, $display) = map{ $STATE->{$_} } qw(uid cid sid view display);

    my $url = "$config->{'cgidir'}/comments.cgi?op=threadlist&sid=$sid&cid=$cid&view=$view&display=$display#$cid";

    if(!$mconfig){
	return (0, $lang->{'not_use_funct'}, "", $url);
    }
 
    my $mlang = SmallPig::get_spmail_lang();

    if(!$mlang){
	return (0, $lang->{'not_use_funct'}, "", $url);
    }

    # --- get the mfid for favorite 
    my $mfnameq = $DBH->quote($mlang->{'favorite'});
    my ($mfid) = $spdb->db_select_cols("mfid", "MailFolders", "uid=$uid AND msid=-2 AND mfname=$mfnameq");
    
    # --- if there is no such mfid, create a new one
    if(!$mfid){
	$spdb->db_lock(("MailFolders"));
	
	my $mmfid = $spdb->db_max("mfid", "MailFolders");
	$mmfid = 0 unless $mmfid; $mmfid++;
	my $mmforder = 0;
	
	my @folders = ($mlang->{'favorite'});
	
	my $tmp = $spdb->db_count("MailFolders", "uid=$uid");
	for(my $i=$mmfid, my $j=0; $i<$mmfid+4; $i++, $j++){
	    if($tmp > 0 && $i>$mmfid){
		last;
	    }
	    
	    my $data = {('mfid'=>$i,
			 'mfname'=>$folders[$j],
			 'msid'=>-2,
			 'uid'=>$uid,
			 'mforder'=>$mmforder)};
	    $spdb->db_insert("MailFolders", $data);
	}

	$spdb->db_unlock();
	$mfid = $mmfid;
    }

    my ($subject, $bodytext, $hits, $ip, $time, $closed, $sid, $tuid,
	$name, $email, $pid, $lastmod, $replies, $privlev, $hasatt) = 
	    $self->_select_comment($cid);
    
    my $date = $spdb->db_date();
    my ($tsubject) = unpack "a10", $subject;

    my $msgid = "<".$self->_file_encode("$date-$tsubject").">";
    
    my $mfrom = "$name " if $name;
    $mfrom .= "<$email>" if $email;
    my $size = length($bodytext);

    $bodytext = SmallPig::recover_markup($bodytext);

    my $data = {'mfid'=>$mfid, 
		'msgid'=>$msgid,
		'mdate'=>$date,
		'mfrom'=>$mfrom,
		'subject'=>$subject,
		'bodytext'=>$bodytext,
		'date'=>$date,
		'new'=>0,
		'size'=>$size,
		'sday'=>0,
		'outgoing'=>0,
		'uid'=>$uid};

    my ($succ, $errmsg) = $spdb->db_insert("MailMessages", $data);
    return (0, $errmsg) unless $succ;

    # --- deal with file attachment
    if($hasatt){
	my $sidq = $DBH->quote($sid);
	my ($fidsa) = 
	    $spdb->db_select_many_new(1, 
				      "fname, fdesc, fsize, fcontenttype, date", 
				      "FileAttach",
				      "cid=$cid AND sid=$sidq");
	
	$spdb->db_lock(("MailAttachments"));
	
	my $date = $spdb->db_date();
	
	if($fidsa){
	    my ($fname1, $fname2);
	    while (my ($fname, $fdesc, $fsize, $ftype, $date1) = $fidsa->fetchrow_array){
		
		my ($maid) = $spdb->db_max("maid", "MailAttachments");
		$maid = 0 if !$maid; $maid++;
		
		my $data = {('maid'=>$maid, 'msgid'=>$msgid, 'fname'=>$fname, 'fdesc'=>$fdesc,
			     'fsize'=>$fsize, 'fcontenttype'=>$ftype, 'date'=>$date)};
		my ($succ, $errmsg) = $spdb->db_insert("MailAttachments", $data);  
		
		$fname1 ="$date-$fname";
		$fname =~ s/(\s+|\\)/-/g;
		open(FILE, "$config->{'file_path'}/$fname1");
		$fname2 = "$date-$fname";
		$fname2 = $self->_file_encode($fname2);
		open(FILE1, ">$mconfig->{'file_path'}/$fname2");
		while(my $line = <FILE>){
		    print FILE1 $line;
		}
		close(FILE);
		close(FILE1);
	    }
	    
	    $spdb->db_handler_done($fidsa);
	
	}
	
	$spdb->db_unlock();
	
    }
    
    return (1, $lang->{'add_msg_fav2'}, $lang->{'add_msg_fav1'}, $url);
    
}

sub _select_the_most_parent{
  my ($template, $cid) = @_;
  my $spdb = $template->{'spdb'};
  
  # --- find out its parentid
  my ($pid) = $spdb->db_select_cols("parentid", "ParentAndChild",
                                   "childid=$cid");
  if(!$pid){
    return $cid;
  }
  else{
      $template->_select_the_most_parent($pid);
  }
}

sub _select_comment{
  my ($template, $cid) = @_;
  my $spdb = $template->{'spdb'};
  
  my ($subject, $bodytext, $hits, $ip, $time,  
      $closed, $sid, $uid, $hasatt) = 
        $spdb->db_select_cols("subject, bodytext, hits, ip, 
                          date_format(date, \"$config->{date_format}\"),
                          closed, sid, uid, hasatt",
                             "Posts", "cid=$cid");
  my ($name, $email, $privlev);
  if($uid != 0){
      ($name, $email, $privlev) = 
          $spdb->db_select_cols("nickname, fakeemail, privlev",
                                "Users", "uid=$uid");
  }
  else{
      ($name, $email) = 
          $spdb->db_select_cols("anon, email", "AnonPosts", "cid=$cid");
  }
  my ($pid) = $spdb->db_select_cols("parentid", "ParentAndChild", 
                                   "childid=$cid");
  
  my $mpid = $template->_select_the_most_parent($cid);
  my ($lastmod, $replies) =
    $spdb->db_select_cols("date_format(lastmod, \"$config->{date_format}\"),
                          replies",
                         "MostParents",
                         "cid=$mpid");

  # --- lang support
  $time =~ s/(jan|feb|mar|apr|may|jun|jul|aug|sep|oct|nov|dec)/$lang->{$1}/ig;
  $lastmod =~ s/(jan|feb|mar|apr|may|jun|jul|aug|sep|oct|nov|dec)/$lang->{$1}/ig;

  return ($subject, $bodytext, $hits, $ip, $time, $closed, $sid, $uid,
          $name, $email, $pid, $lastmod, $replies, $privlev, $hasatt);
}

sub _select_children{
  my ($self, $cid, $children) = @_;
  my $spdb = $self->{'spdb'};
  
  my ($tmp) = $spdb->db_select_many_new(1, "childid", "ParentAndChild", 
					"parentid=$cid");
  if(!$tmp){
    return $children;
  }
  else{
    while (my ($childid) = $tmp->fetchrow_array){
      unshift @$children, $childid;
      $self->_select_children($childid, $children);
    }

    $spdb->db_handler_done($tmp);

  }
}

sub _select_the_least_child{
  my ($self, $cid, $cnt) = @_;
  my $spdb = $self->{'spdb'};
  
  # --- find out its parentid
  my ($childid) = $spdb->db_select_cols("childid", "ParentAndChild",
                                        "parentid=$cid");
  if(!$childid){
      return ($cid, $cnt);
  }
  else{
      $self->_select_the_least_child($childid, $cnt+1);
  }
}

# --- expire threads
sub select_the_least_child{
    my ($self, $cid) = @_;
    my $spdb = $self->{'spdb'};

    my ($childids) = $spdb->db_select_many_new(1, "childid", "ParentAndChild",
					       "parentid=$cid");
    my ($scid, $scnt, $cnt, $where, $date);
    my $scnt = 0;
    
    if($childids){

	while (my ($childid) = $childids->fetchrow_array){
	    ($scid, $cnt) = $self->_select_the_least_child($childid, 1);
	    $scnt += $cnt;
	    $where = "cid=$scid OR ";
	}
	$where =~ s/(.+) OR $/$1/;
	
	$spdb->db_handler_done($childids);

    }
    
    ($scid, $date) = $spdb->db_select_cols("cid, MAX(date)", 
                                           "Posts", $where, 
                                           "GROUP BY sid");
    return ($scid, $scnt, $date);
}


return 1;

