#include "lashdriver.h"
#include <gtk/gtk.h>            /* for idle callback */
#include <string.h>
#include "beef.h"
#include "gui/gui.h"

lash_client_t* lash_client;


void lashdriver_init (int* argc, char*** argv)
{
    lash_args_t* lash_args = lash_extract_args(argc, argv);

    lash_client = lash_init(lash_args, "Specimen", LASH_Config_File, LASH_PROTOCOL(2, 0));

    if (!lash_client)
        fprintf(stderr, "Could not initialise LASH\n");

    lash_event_t* event = lash_event_new_with_type(LASH_Client_Name);
    lash_event_set_string(event, "Specimen");
    lash_send_event(lash_client, event);
}


gboolean lashdriver_process (void* absolutely_nothing)
{
    lash_event_t*  event  = NULL;
    lash_config_t* config = NULL;
    const char*    str    = NULL;
    char*          path   = NULL;
    
    while ((event = lash_get_event(lash_client)))
    {
        if (lash_event_get_type(event) == LASH_Quit)
        {
            gtk_main_quit();
            return FALSE;
        }
        else if (lash_event_get_type(event) == LASH_Save_File)
        {
            str = lash_event_get_string(event); /* our restore directory */
            path = (char*)calloc(strlen(str)+11, sizeof(char));
            strcpy(path, str);         /* path = dir */
            strcat(path, "/");         /* path += "/" */
            strcat(path, "bank.beef"); /* path += "bank.beef" */
            fprintf(stderr, "Saving to file %s\n", path);
            beef_write(path);
        }
        else if (lash_event_get_type(event) == LASH_Restore_File)
        {
            str = lash_event_get_string(event); /* our restore directory */
            path = (char*)calloc(strlen(str)+11, sizeof(char));
            strcpy(path, str);         /* path = dir */
            strcat(path, "/");         /* path += "/" */
            strcat(path, "bank.beef"); /* path += "bank.beef" */
            fprintf(stderr, "Restoring from file %s\n", path);
            beef_read(path);
            gui_refresh();
        }
        else 
        {
            fprintf(stderr, "Unhandled LASH event: type %d, '%s''\n",
                    lash_event_get_type(event),
                    lash_event_get_string(event));
        }
    }

    while ((config = lash_get_config(lash_client)))
    {
        fprintf(stderr, "Unexpected LASH config: %s\n",
                lash_config_get_key(config));
    }

    return TRUE;
}


void lashdriver_start ( )
{
    gtk_timeout_add(250, lashdriver_process, NULL);
}

