//************************************************************
// config.h - configuration classes for the spk client/server
//  Author Eugene Anikin     anikin@anikin.ddns.org
//************************************************************

class ConfigInfo
{
   public:
      char* SerialPort;
      char* CommandSet;      // File with command-set of the modem
      char* FirstActionFile; // Start with this response file. Section: "START"
      char* GSPKPath;   // location of the Tcl/Tk script

      char* Counter;
      char* DefPath;    // Path to any file if it does not start with '/'
      char* LockPath;   // Usually it is /var/lock
      char* RunPath;    // Usually it is /var/run

      int   CheckGSM;   // Should we check and remove GSM frames
      int   TestLocal;  // Use local handset to test spk
      int   PortSpeed;  // Port speed in voice mode
      int   UseCallerID;// Whether we should use caller ID feature
      int   SpkCapable; // Whether the modem is speakerphone-capable

      ConfigInfo();
      ConfigInfo(ConfigInfo* conf);
      ~ConfigInfo();

      void ReadConfig(char* FName);
      void SaveConfig(char* FName);

      // Make full path name from FName. If FName does not start
      // with '/', it will be concatenated with DefPath.
      char* CreateFullPath(char* FName);
};
