% -----------------------------------------------------------------------------
%  (C) Altran Praxis Limited
% -----------------------------------------------------------------------------
% 
%  The SPARK toolset is free software; you can redistribute it and/or modify it
%  under terms of the GNU General Public License as published by the Free
%  Software Foundation; either version 3, or (at your option) any later
%  version. The SPARK toolset is distributed in the hope that it will be
%  useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
%  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
%  Public License for more details. You should have received a copy of the GNU
%  General Public License distributed with the SPARK toolset; see file
%  COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
%  the license.
% 
% =============================================================================


/*** STAND_ALL - (update) standardisation of all hypotheses of the VC ***/
stand_all :-
        vc_standardisation(off),
        !.

stand_all :-
        hyp(N,_X),
        integer(N),
        stan_hyp(N),
        fail.

stand_all.


/*** STAN_HYP(N) -- standardise, and if possible semi-standardise, hyp N ***/
stan_hyp(N) :-
        hyp(s(N),_),
        !.

stan_hyp(N) :-
        \+ hyp(s(N),_),
        hyp(N,X),
        norm_typed_expr(X,boolean,X1),
        assertz(hyp(s(N),X1)),
        semi_stan(N,X),
        !.


/*** SEMI_STAN(N,FORMULA) -- semi-standardise relational FORMULA, hyp N ***/
semi_stan(N,X1=X2) :-
        checktype(X1,T),
        norm_typed_expr(X1,T,Y1),
        norm_typed_expr(X2,T,Y2),
        assertz(hyp(ss(N),Y1=Y2)),
        !.

semi_stan(N,X1<>X2) :-
        checktype(X1,T),
        norm_typed_expr(X1,T,Y1),
        norm_typed_expr(X2,T,Y2),
        assertz(hyp(ss(N),Y1<>Y2)),
        !.

semi_stan(N,X1>X2) :-
        norm_typed_expr(X1,integer,Y1),
        norm_typed_expr(X2,integer,Y2),
        assertz(hyp(ss(N),Y1>Y2)),
        !.

semi_stan(N,X1<X2) :-
        norm_typed_expr(X1,integer,Y1),
        norm_typed_expr(X2,integer,Y2),
        assertz(hyp(ss(N),Y1<Y2)),
        !.

semi_stan(N,X1>=X2) :-
        norm_typed_expr(X1,integer,Y1),
        norm_typed_expr(X2,integer,Y2),
        assertz(hyp(ss(N),Y1>=Y2)),
        !.

semi_stan(N,X1<=X2) :-
        norm_typed_expr(X1,integer,Y1),
        norm_typed_expr(X2,integer,Y2),
        assertz(hyp(ss(N),Y1<=Y2)),
        !.

semi_stan(N,not X) :-
        neg(X,Y),
        Y\=(not _),
        semi_stan(N,Y),
        !.
%###############################################################################
%END-OF-FILE
