#! /usr/bin/perl
###############################################################################
#
# $Id: Email.pl,v 1.5 1998/10/21 13:39:46 bcwhite Exp $
#
# Email.pm
#
# Written by: Behan Webster <behanw@pobox.com>
#


###########################################################################
# Parse out all email addresses
#
sub parseAddr {
	my @email;

	foreach ( @_ ) {
		s/^[^:]+:\s*//;					# Remove name
		s/\\\"//g;						# Remove quoted quotes
		s/\".*?\"//g;					# Remove quoted information
		foreach ( split(/\s*,\s*/) ) {
			s/^.*<(\S+?)>.*$/$1/;		# Parse "name <email>"
			s/^(\S+?)\s+\(.*$/$1/;		# Parse "email (name)"
			s/^.*?(\S+\@\S+).*?$/$1/;	# Pick out the email address w/domain
			s/^.*?(\S+).*?$/$1/;		# Pick out first word if no domain
			push( @email, lc $_ );
		}
	}

	@email;
}


###########################################################################
# Parse out the header and body of an email message
#
sub parseEmail {
	my ($header, $rawhead, $rawbody) = @_;
	my $name;

	#
	# Parse the headers
	#
	$$rawhead = "";
	while( <STDIN> ) {
		$$rawhead .= $_;				# Save old header
		chomp;
		next if /^>?From /;				# Get rid of "From " lines
		last if /^\s*$/;				# Detect end of headers
		if( /^([^\s:]+):\s+(.*)$/ ) {	# New header
			$name = lc $1;
			$$header{$name} = $2;
		} else {						# Append data to previous header
			s/^\s+/ /;					# Get rid of leading whitespace
			$$header{$name} .= $_;
		}
	}

	#
	# Get the body
	#
	$$rawbody = "";
	while( <STDIN> ) {
		last if /^From /;				# Next mail message
		s/^\.$/. /;						# Escape single dot which means EOF
		$$rawbody .= $_;				# Save body
	}
}


###########################################################################
# Send email
#
sub sendEmail {
	my ($header, $body, @to) = @_;

	#
	# Open pipe to sendmail
	#
	my $sendmail = "/usr/lib/sendmail";
	my $opts;
	if( $to[0] ) {
		$opts = join(" ", @to);
	} else {
		$opts = "-t";
	}
	if( $$header{'test'} ) {
		print "$sendmail $opts\n";
	} else {
		open(MAIL, "| $sendmail $opts") || die "$sendmail: $!";
		select( MAIL );
	}

	#
	# Print headers
	#
	if( ref($header) ) {
		my ($key, $value);
		while (($key,$value) = each %$header) {
			print "\u$key: $value\n" if $key !~ /^test$/;
		}
	} else {
		print "$header\n";
	}
	print "\n";

	#
	# Print the body
	#
	if( ref($body) ) {
		print $$body;
	} else {
		print $body;
	}

	close( MAIL );
	select( STDOUT );
}

1;
