<?php
/**
 * $Horde: vacation/main.php,v 1.55.2.8 2009/01/29 11:57:30 jan Exp $
 *
 * Copyright 2001-2009 The Horde Project (http://www.horde.org/)
 *
 * See the enclosed file LICENSE for license information (BSD). If you
 * did not receive this file, see http://www.horde.org/licenses/bsdl.php.
 *
 * @author Eric Rostetter <eric.rostetter@physics.utexas.edu>
 * @author Jan Schneider <jan@horde.org>
 */

@define('VACATION_BASE', dirname(__FILE__));
require_once VACATION_BASE . '/lib/base.php';
require_once 'Horde/MIME.php';

// Create a driver.
require_once VACATION_BASE . '/lib/Driver.php';
require_once VACATION_BASE . '/lib/AliasDriver.php';
$driver = Vacation_Driver::factory(Auth::getAuth());

// Check if hordeauth is set to 'full'
$hordeauth = $driver->getParam('hordeauth');

if (Util::getFormData('submit')) {
    $vacationmode = Util::getFormData('mode', 'error');
    if ($vacationmode === 'error') {
        $notification->push(_("You must specify the mode (set or remove)"),
                            'horde.warning');
    }

    // Check for refused usernames, using current horde username.
    if (in_array($driver->getUser(), $conf['user']['refused'])) {
        $notification->push(sprintf(_("You can't change the vacation notice for %s."),
                                    $driver->getUser()),
                            'horde.error');
        $vacationmode = 'error';
    } else {
        // Check for password
        if (empty($hordeauth)) {
            $password = Util::getFormData('password');
            if (empty($password)) {
                $notification->push(_("You must give your password"), 'horde.warning');
                $vacationmode = 'error';
            }
        } else {
            $password = Auth::getCredential('password');
        }
    }

    // Call the requested function.
    switch ($vacationmode) {
    case 'set':
        if ($conf['aliases']['show']) {
            $alias = Util::getFormData('alias');
        } else {
            $aliases = Vacation_AliasDriver::factory($driver->getUser());
            $alias_list = $aliases->getAliasesForUser();
            $alias = count($alias_list) ? join(', ', $alias_list) : '';
        }

        $message = Util::getFormData('mess');
        if (empty($message)) {
            $notification->push(_("You must give a vacation message."),
                                'horde.error');
            break;
        }
        if (!empty($conf['vacation']['validation_pattern']) &&
            !preg_match($conf['vacation']['validation_pattern'], $message)) {
            // Validation is required, and wasn't matched.
            $notification->push(_("Your vacation message is not in the proper format."),
                                'horde.error');
            break;
        }

        $result = $driver->setVacation($password, $message,
                                       Util::getFormData('subject'),
                                       Util::getFormData('from'), $alias);
        if (is_a($result, 'PEAR_Error')) {
            $notification->push($result);
        } else {
            $notification->push(_("Vacation notice successfully enabled."),
                                'horde.success');
        }
        break;

    case 'unset':
        $result = $driver->unsetVacation($password);
        if (is_a($result, 'PEAR_Error')) {
            $notification->push($result);
        } else {
            $notification->push(_("Vacation notice successfully removed."),
                                'horde.success');
        }
        break;
    }
}

// If we can tell whether vacation notices are enabled, then say so. But if
// this fails, it could be because it is disabled, or just because we can't
// tell, so just be quiet about it.
$onVacation = false;
$curmessage = $cursubject = $curfrom = '';
$pass       = Auth::getCredential('password');
$status     = $driver->isEnabled($pass);
$curmessage = $driver->currentMessage($pass);
$cursubject = $driver->currentSubject($pass);
$curfrom    = $driver->currentFrom($pass);

// Only show the status error if there is one, to avoid multiple errors of the
// same kind.
if (is_a($status, 'PEAR_Error')) {
    $notification->push($status);
} else {
    if (is_a($curmessage, 'PEAR_Error')) {
        $notification->push($curmessage);
    }
    if (is_a($cursubject, 'PEAR_Error')) {
        $notification->push($cursubject);
    }
    if (is_a($curfrom, 'PEAR_Error')) {
        $notification->push($curfrom);
    }
    if ($status === 'Y') {
        $notification->push(_("Your vacation notice is currently enabled."),
                            'horde.message');
        $onVacation = true;
    } elseif ($status === 'N') {
        if (empty($curmessage)) {
            $curmessage = $conf['vacation']['default'];
        }
        $notification->push(_("Your vacation notice is currently disabled."),
                            'horde.message');
    }
}
if (is_a($curmessage, 'PEAR_Error')) {
    $curmessage = $GLOBALS['conf']['vacation']['default_message'];
}
if (is_a($cursubject, 'PEAR_Error')) {
    $cursubject = $GLOBALS['conf']['vacation']['default_subject'];
}
if (is_a($curfrom, 'PEAR_Error')) {
    $curfrom = $driver->getFrom();
}

$alias = Util::getFormData('alias');
if (is_null($alias)) {
    $aliases = Vacation_AliasDriver::factory($driver->getUser());
    $alias_list = $aliases->getAliasesForUser();
    if (is_array($alias_list) && count($alias_list)) {
        $alias = join(', ', $alias_list);
    }
}

$title = _("Change Vacation Notices");
require VACATION_TEMPLATES . '/common-header.inc';
require VACATION_TEMPLATES . '/main/main.inc';
require $registry->get('templates', 'horde') . '/common-footer.inc';
