<?php
/**
 * $Horde: forwards/main.php,v 1.36.2.4 2009/01/06 15:22:46 jan Exp $
 *
 * Copyright 2001-2009 The Horde Project (http://www.horde.org/)
 *
 * See the enclosed file LICENSE for license information (BSDL). If you
 * did not receive this file, see http://www.horde.org/licenses/bsdl.php.
 *
 * @author Eric Rostetter <eric.rostetter@physics.utexas.edu>
 * @author Jan Schneider <jan@horde.org>
 */

@define('FORWARDS_BASE', dirname(__FILE__));
require_once FORWARDS_BASE . '/lib/base.php';

// Get the current login username and realm.
@list(, $realm) = explode('@', Auth::getAuth(), 2);
if (empty($realm)) {
    $realm = 'default';
}

// Create a driver.
require_once FORWARDS_BASE . '/lib/Driver.php';
$driver = Forwards_Driver::factory(Auth::getAuth(), $realm);

if (Util::getFormData('submit')) {
    $forwardmode = Util::getFormData('mode', 'error');
    if ($forwardmode === 'error') {
        $notification->push(_("You must specify the mode (set or remove)"), 'horde.warning');
    }

    // Check for refused usernames, using current horde username.
    if (in_array($driver->getUser(), $conf['user']['refused'])) {
        $notification->push(sprintf(_("You can't change Forwards for user %s"), $driver->getUser()),
                            'horde.error');
        $forwardmode = 'error';
    }

    if ($conf['enabled']['authenticate']) {
        $password = Util::getFormData('password');
        if (!$password) {
            $notification->push(_("You must give your password"), 'horde.warning');
            $forwardmode = 'error';
        }
    } else {
        $password = Auth::getCredential('password');
    }

    $metoo = Util::getFormData('metoo');
    if ($metoo != 'on') {
        $metoo = 'off';
    }

    // Do the action requested.
    switch ($forwardmode) {
    case 'set':
        $forwardwhere = Util::getFormData('where');
        if (!$forwardwhere) {
            $notification->push(_("You must supply an e-mail address!"), 'horde.warning');
        } else {
            $result = $driver->enableForwarding($password, $forwardwhere, $metoo);
            if (is_a($result, 'PEAR_Error')) {
                $notification->push($result);
            } else {
                $notification->push(_("Forward set!"), 'horde.success');
            }
        }
        break;

    case 'unset':
        $result = $driver->disableForwarding($password);
        if (is_a($result, 'PEAR_Error')) {
            $notification->push($result);
        } else {
            $notification->push(_("Forward removed!"), 'horde.success');
        }
        break;
    }
}

// The backend always returns 'Y' if forwarding is enabled, but may not be
// able to say with certainty that forwarding is *disabled* - 'N' means "there
// is definitely no forwarding address set", false means that we can't
// determine the current state.
$password = Auth::getCredential('password');
$enabled = $driver->isEnabledForwarding($password);
$current_target = '';
$current_keeplocal = '';
if (is_a($enabled, 'PEAR_Error')) {
    $notification->push($enabled);
    $enabled = false;
} else {
    if ($enabled == 'Y') {
        $notification->push(_("Forwarding is currently enabled."), 'horde.message');
        $current_target = $driver->currentTarget($password);
        if (is_a($current_target, 'PEAR_Error')) {
            $notification->push($current_target);
            $current_target = '';
        }
        $current_keeplocal = $driver->isKeepLocal($password);
        if (is_a($current_keeplocal, 'PEAR_Error')) {
            $notification->push($current_keeplocal);
            $current_keeplocal = '';
        }
    } elseif ($enabled == 'N') {
        $notification->push(_("Forwarding is currently disabled."), 'horde.message');
    }
}

$notification->push('setFocus()', 'javascript');
$title = _("Set or Remove E-Mail Forwards");
require FORWARDS_TEMPLATES . '/common-header.inc';
require FORWARDS_TEMPLATES . '/main/main.inc';
require $registry->get('templates', 'horde') . '/common-footer.inc';
