/*  Sonicmail - POP3 email notifier
 *  Copyright (C) 2000  Cameron Edwards
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#ifndef SONICMAIL_DEBUG_H_INCLUDED
#define SONICMAIL_DEBUG_H_INCLUDED

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>

/* Define the debug macros (use these not the functions): */
#if SONICMAIL_DEBUG

#define SM_DEBUG(s) sonicmail_debug((s), __FILE__, __LINE__);
#define SM_DEBUG_INT(s,a) sonicmail_debug_int((s), (a), __FILE__, __LINE__);
#define SM_DEBUG_STRING(s,a) sonicmail_debug_string((s), (a), __FILE__, __LINE__);

#else

#define SM_DEBUG(s) 
#define SM_DEBUG_INT(s,a) 
#define SM_DEBUG_STRING(s,a) 

#endif
/* Use the above macros, not these functions directly: */
void sonicmail_debug(char *str, char *file, int line);
void sonicmail_debug_int(char *str, int arg, char *file, int line);
void sonicmail_debug_string(char *str, char *arg, char *file, int line);


#endif
