dnl Get GNOME cflags and libs:

AC_DEFUN(AC_CHECK_GNOME,
[
  
   AC_PATH_PROG(GNOME_CONFIG, gnome-config, no)

   if test "$GNOME_CONFIG" = "no" ; then
      AC_MSG_ERROR(Cannot find GNOME: Is gnome-config in path?)
   
   else
      GNOME_CFLAGS=`$GNOME_CONFIG --cflags $1`
      GNOME_LIBS=`$GNOME_CONFIG --libs $1`
   fi
   dnl AC_CHECKING(GNOME cflags is: $GNOME_CFLAGS)
])


dnl Get gthread cflags and libs:

AC_DEFUN(AC_CHECK_GTK,
[
  
   AC_PATH_PROG(GTK_CONFIG, gtk-config, no)
  
   if test "$GTK_CONFIG" = "no" ; then
      AC_MSG_ERROR(Cannot find GTK: Is gtk-config in path?)
   
   else
      GTK_LIBS=`$GTK_CONFIG --libs $1`
   fi
   dnl AC_CHECKING(GTK libs is: $GTK_LIBS)
   
])


AC_DEFUN(AC_GET_SONICMAIL_PATHS,
[

dnl Set XPMSPATH & WAVSPATH in config.h.
   
   if test "x${datadir}" = 'x${prefix}/share'; then
      if test "x${prefix}" = "xNONE"; then
         AC_DEFINE_UNQUOTED(XPMSPATH, "${ac_default_prefix}/share/pixmaps/sonicmail", Sonicmail pixmaps path)
         AC_DEFINE_UNQUOTED(WAVSPATH, "${ac_default_prefix}/share/sounds/sonicmail", Sonicmail sound files path)
 
      else
         AC_DEFINE_UNQUOTED(XPMSPATH, "${prefix}/share/pixmaps/sonicmail", Sonicmail pixmaps path)
         AC_DEFINE_UNQUOTED(WAVSPATH, "${prefix}/share/sounds/sonicmail", Sonicmail sound files path)
      fi
   else
      AC_DEFINE_UNQUOTED(XPMSPATH, "${datadir}/pixmaps/sonicmail", Sonicmail pixmaps path)
      AC_DEFINE_UNQUOTED(WAVSPATH, "${datadir}/sounds/sonicmail", Sonicmail sound files path)
   fi
])


AC_DEFUN(AC_GET_SONICMAIL_DEBUG,
[   
   AC_ARG_ENABLE(sonicmail-debug,
      [  --enable-sonicmail-debug Print Sonicmail debug messages],
      sm_debug="$enableval", sm_debug="no")
   
   if test "$sm_debug" = "yes"; then
      AC_DEFINE(SONICMAIL_DEBUG, 1, Sonicmail debug mode)
   else
      AC_DEFINE(SONICMAIL_DEBUG, 0, Sonicmail debug mode)
   fi
])
