/* Somaplayer - Copyright (C) 2003-5 bakunin - Andrea Marchesini 
 *                                     <bakunin@autistici.org>
 *
 * This source code is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Public License as published 
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * This source code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * Please refer to the GNU Public License for more details.
 *
 * You should have received a copy of the GNU Public License along with
 * this source code; if not, write to:
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * This program is released under the GPL with the additional exemption that
 * compiling, linking, and/or using OpenSSL is allowed.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#else
# error Use configure; make; make install
#endif

#ifdef ENABLE_DAEMON

#include "../../player.h"
#include "../../audio.h"
#include "../../util.h"
#include "../../other.h"
#include "../../output.h"
#include "monitor.h"

void
monitor_close (audio * output)
{
}

void
monitor_show (audio * output)
{
  msg (_("Audio Device:\n\tType: Remote Monitor\n"));
}

int
monitor_init (audio * output, long rate, int channels, int bitrate)
{
  return 0;
}

int
monitor_write (audio * output, int channels, int bitrate, void *data,
	       size_t length)
{
  daemon_client *c = (daemon_client *) output->data;
  int k;
  char *d1, *d2 = (char *) data;

  if (c->bigendian == big_endian ())
    d1 = d2;

  else
    {
      if (!(d1 = (char *) malloc (sizeof (char) * length)))
	fatal (_("Error: memory."));

      for (k = 0; k < length / 2; k += 2)
	{
	  d1[k] = d2[k + 1];
	  d1[k + 1] = d2[k];
	}
    }

  k = write (c->fd, d1, length);

  if (k < 1)
    {
      close (c->fd);
      free (c);
      return k;
    }

  if (c->bigendian != big_endian ())
    free (d1);

  return k;
}

#endif
