/* Somaplayer - Copyright (C) 2003-5 bakunin - Andrea Marchesini 
 *                                     <bakunin@autistici.org>
 *
 * This source code is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Public License as published 
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * This source code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * Please refer to the GNU Public License for more details.
 *
 * You should have received a copy of the GNU Public License along with
 * this source code; if not, write to:
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * This program is released under the GPL with the additional exemption that
 * compiling, linking, and/or using OpenSSL is allowed.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#else
# error Use configure; make; make install
#endif

#include "../player.h"
#include "../audio.h"
#include "../fconfig.h"
#include "graphic.h"

void
on_save_playlist_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  char s[1024];
  char *file;

  if (!playing_list ())
    {
      dialog_msg ("No playlist present.");
      return;
    }

  snprintf (s, 1024, "%s %s - Choose your playlist", NAME, VERSION);
  if((file=file_chooser(s, GTK_SELECTION_SINGLE, GTK_FILE_CHOOSER_ACTION_SAVE)))
    {
      playlist_save (file);
      free (file);
    }
}

void
on_save_configuration_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  config_write ();

  dialog_msg ("Configuration saved.");
}

void
on_quit_activate (GtkMenuItem * menuitem, gpointer user_data)
{

  graphic_save_size (winmain->allocation.width, winmain->allocation.height);

  gtk_widget_hide (winmain);
  gtk_widget_hide (winsearch);

  playlist_dump ();

  events.quit = 1;

  if (events.pause)
    events.pause = 0;
  if (events.stop)
    events.stop = 0;

  pthread_cond_signal (&play->p_pop);
  pthread_join (th1, NULL);

  play->go_graphic = 0;

  gtk_main_quit ();

  return;
}

/* EOF */
