/*
 * ----------------------------------------------------
 *
 * Debugserver: listen on a TCP port and create 
 *		a command editor shell
 *
 * (C) 2004 2005  Jochen Karrer 
 *   Author: Jochen Karrer
 *
 *
 *  This program is free software; you can distribute it and/or modify it
 *  under the terms of the GNU General Public License (Version 2) as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope it will be useful, but WITHOUT
 *  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 *  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 *  for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place - Suite 330, Boston MA 02111-1307, USA.
 *
 * ----------------------------------------------------
 */


#include <fio.h>
#include <stdint.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>
#include <unistd.h>
#include <cmdedit.h>
#include <configfile.h>
#include <debugserver.h>
#include <telnetd.h>
#include <interpreter.h>

#if 1
#define dprintf(x...) { fprintf(stderr,x); }
#else
#define dprintf(x...)
#endif


typedef struct DebugSession {
	DbgInterp *interp;	
	TelnetSession *ts;
} DebugSession;

struct Debugger {
	TelnetServer *tserv;
};

static void * 
Dbg_SessionNew(TelnetSession *ts,void *cd) 
{
	DebugSession *session = malloc(sizeof(DebugSession));
	if(!session) {
		fprintf(stderr,"can not allocate memory for debugsession\n");
		exit(34356);
	}
	session->ts=NULL;
	dprintf("New debug session\n");
	return session;
}

static void 
Dbg_SessionClose(TelnetSession *ts,void *owner)
{
	DebugSession *session = owner;
	dprintf("debug session close\n");
	free(session);
}

static int
Dbg_Send(TelnetSession *ts, void *owner, uint8_t *buf, int len) 
{
	return 0;
}

static int 
Dbg_Feed(TelnetSession *ts,void *owner,uint8_t *buf,int len) 
{

	return 0;
}

static TelnetOps debugger_ops = {
	.open = Dbg_SessionNew,
	.close = Dbg_SessionClose,
	.feed = Dbg_Feed,
	.send = Dbg_Send,
}; 

Debugger *
Debugger_New() {
	Debugger *dbg = malloc(sizeof(Debugger));
	char *host=Config_ReadVar("debugshell","host");	
	int port;	
	if(!dbg) {
		fprintf(stderr,"Out of memory for debugger\n");
		return NULL;
	}
	if(Config_ReadInt32(&port,"debugshell","port")<0) {
		fprintf(stderr,"Debugshell not configured\n");
		return NULL;
	} 
	if(!host) {
		fprintf(stderr,"No host for TCP server of debugshell\n");
		return NULL;
	}
	dbg->tserv = TelnetServer_New(host,port, &debugger_ops,dbg);
	return dbg;
}
