/*
 * ------------------------------------------------------------------------
 * 
 * Command Line Editor for Debug-Shell
 * (C) 2004  Jochen Karrer
 *   Author: Jochen Karrer
 *   State: nothing is working
 *
 *  This program is free software; you can distribute it and/or modify it
 *  under the terms of the GNU General Public License (Version 2) as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope it will be useful, but WITHOUT
 *  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 *  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 *  for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place - Suite 330, Boston MA 02111-1307, USA.
 *
 * ------------------------------------------------------------------------
 */

#if 0
#define dprintf(x...) { fprintf(stderr,x); }
#else
#define dprintf(x...)
#endif

#include <fio.h>
#include <stdint.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>
#include <unistd.h>
#include <errno.h>
#include <cmdedit.h>
#include <sys/socket.h>
#include <arpa/telnet.h>


#define MAX_CMDLINE_LEN (1024)
#define HISTORY_LINES (100)

typedef struct CmdEditor {
	char *history[HISTORY_LINES];
	char current_line[MAX_CMDLINE_LEN];
	int history_wp;
	int current_p;
	int state;
} CmdEditor;

CmdEditor *
CmdEditor_New() {
	CmdEditor *ce;
	ce = malloc(sizeof(CmdEditor));
	if(!ce) {
		fprintf(stderr,"Out of memory\n");
		exit(4324);
	}
	memset(ce,0,sizeof(CmdEditor));
	return ce;
}

void
CmdEditorFeed(CmdEditor *ce,uint8_t c) 
{

#if 0
		switch(c) {
			case '\r':
			case '\n':
				dprintf("Newline\n");
				if(ts->echo) {
					telnet_outstr(ts,"\n\r");
				}
				if(!strcmp(ts->cmdline,"quit")) {
					telnet_outstr(ts,"Bye\n\r");
					TS_Del(ts);
					return -1;
				}
				telnet_outstr(ts,"Executing commands is not implemented\n\r");
				prompt(ts);
				ts->cmdline_wp=0;
				ts->cmdline[0]=0;
				break;

			case 0x7f:
				if(ts->cmdline_wp>0) {
					ts->cmdline_wp--;
					ts->cmdline[ts->cmdline_wp]=0;
				}
				reply[0] = 0x1b;
				reply[1] = 0x5b;
				reply[2] = 0x44;
				reply[3] = 0x20;
				telnet_output(ts,reply,4);
				prompt(ts);
				telnet_outstr(ts,ts->cmdline);
				break;

			case 0:
				break;
			default:
				if(ts->echo) {
					telnet_output(ts,&c,1);
				}
				if(ts->cmdline_wp+1<MAX_CMDLINE_LEN) {
					ts->cmdline[ts->cmdline_wp]=c;
					ts->cmdline_wp++;
					ts->cmdline[ts->cmdline_wp]=0;
				}
	}
#endif
}	
