Name: sndconfig
Version: 0.67
Release: 1
License: GPL
Summary: The Red Hat Linux sound configuration tool.
Group: Applications/Multimedia
Source: sndconfig-%{PACKAGE_VERSION}.tar.bz2
Requires: sox kudzu
%ifarch i386 alpha
Requires: aumix, kernel >= 2.4.0
%endif
BuildPrereq: kudzu-devel >= 0.97, sharutils, newt-devel
Conflicts: modutils < 2.3.11-5
BuildRoot: %{_tmppath}/%{name}-root
ExclusiveArch: %{ix86} sparc alpha ia64

%description
Sndconfig is a text based tool which sets up the configuration files
you'll need to use a sound card with a Red Hat Linux system.
Sndconfig can be used to set the proper sound type for programs which
use the /dev/dsp, /dev/audio and /dev/mixer devices.  The sound
settings are saved by the aumix and sysV runlevel scripts.

%prep
%setup -q

%build
make RPM_OPT_FLAGS="$RPM_OPT_FLAGS"

%install
rm -rf $RPM_BUILD_ROOT
make prefix=$RPM_BUILD_ROOT/usr mandir=$RPM_BUILD_ROOT/%{_mandir} install

mkdir -p $RPM_BUILD_ROOT/sbin
mv $RPM_BUILD_ROOT/usr/sbin/sndconfig $RPM_BUILD_ROOT/sbin
ln -s ../../sbin/sndconfig $RPM_BUILD_ROOT/usr/sbin/sndconfig

%find_lang %{name}

%clean
rm -rf $RPM_BUILD_ROOT

%files -f %{name}.lang
%defattr (-,root,root)
/sbin/sndconfig
/usr/sbin/sndconfig
/usr/share/sndconfig
%{_mandir}/man8/sndconfig.*

%changelog
* Sat Apr  6 2002 Bill Nottingham <notting@redhat.com> 0.67-1
- fix cancel button (#60950)

* Fri Jan 25 2002 Bill Nottingham <notting@redhat.com> 0.66-1
- remove playmidi/awesfx requirements, and midi test

* Tue Aug 28 2001 Trond Eivind Glomsrd <teg@redhat.com> 0.65.2-1
- Translation update

* Tue Aug 21 2001 Bill Nottingham <notting@redhat.com>
- don't remove the cs4232 module when we go to load opl3 either (#52176)

* Mon Jul 23 2001 Trond Eivind Glomsrd <teg@redhat.com>
- Translation update

* Fri Jul  6 2001 Bill Nottingham <notting@redhat.com>
- own /usr/share/sndconfig

* Mon May 21 2001 Bill Nottingham <notting@redhat.com>
- fix segfault when LANG is unset (#41394)

* Fri Mar 30 2001 Bill Nottingham <notting@redhat.com>
- add translation files

* Thu Mar 22 2001 Preston Brown <pbrown@redhat.com>
- update japanese translation

* Mon Mar 19 2001 Bill Nottingham <notting@redhat.com>
- add 'support' for the Inspiron 3500, and potentially other wacky
  nm256 stuff (#19685)
- fix aumix lines, again (#32163)

* Fri Mar 16 2001 Bill Nottingham <notting@redhat.com>
- don't unload sb before trying to load opl3

* Tue Mar 13 2001 Bill Nottingham <notting@redhat.com>
- write *correcct* save/restore lines for aumix
- use correct driver for the nm256
- use sox for all PCI cards

* Wed Feb 28 2001 Bill Nottingham <notting@redhat.com>
- fix a segfault if no cards are probed

* Wed Feb 28 2001 Than Ngo <than@redhat.com>
- add require aumix (bug #29946)

* Tue Feb 27 2001 Bill Nottingham <notting@redhat.com>
- kill the userland isapnp code, switch to dealing with the kernel isapnp
  (part of #29450)
- link in newt/slang statically (bleah), put sndconfig on the root partition
- rebuild

* Tue Feb 20 2001 Bill Nottingham <notting@redhat.com>
- add lines to modules.conf to save/restore sound settings (#28504)

* Wed Feb 14 2001 Preston Brown <pbrown@redhat.com>
- last translation update.

* Wed Feb 14 2001 Bill Nottingham <notting@redhat.com>
- add cs4281, fix some driver mappings
- die, code, die.

* Tue Feb  6 2001 Bill Nottingham <notting@redhat.com>
- don't write modules.conf until we're sure it works (patch originally from
  <denice@deatrich@epfl.ch>)

* Mon Feb  5 2001 Bill Nottingham <notting@redhat.com>
- add a special dialog for disabled devices

* Wed Jan 24 2001 Preston Brown <pbrown@redhat.com>
- final i18n update before beta
- use lang finder macro

* Mon Dec 11 2000 Bill Nottingham <notting@redhat.com>
- fix emu10k1 on 2.4. Wow, this code must *die*.

* Fri Nov 17 2000 Bill Nottingham <notting@redhat.com>
- ugly hacks for ftsodell support

* Mon Nov  6 2000 Bill Nottingham <notting@redhat.com>
- add Maestro3 support

* Thu Aug 24 2000 Erik Troan <ewt@redhat.com>
- updated it/es translations

* Wed Aug 23 2000 Bernhard Rosenkraenzer <bero@redhat.com>
- kernel 2.4 support in FindModules (Bug #16779)

* Sun Aug 20 2000 Matt Wilson <msw@redhat.com>
- new translations

* Tue Aug 15 2000 Bill Nottingham <notting@redhat.com>
- fix sound test on maestro cards

* Wed Aug  9 2000 Bill Nottingham <notting@redhat.com>
- translation updates

* Sun Aug  6 2000 Bill Nottingham <notting@redhat.com>
- newt fixes

* Sat Aug  5 2000 Bil lNottingham <notting@redhat.com>
- fix PCI probing

* Fri Aug  4 2000 Bill Nottingham <notting@redhat.com>
- fix ymfsb driver mapping
- random translation/message fixes

* Tue Jul 25 2000 Bill Nottingham <notting@redhat.com>
- actually build version with cs46xx support

* Tue Jul 18 2000 Bill Nottingham <notting@redhat.com>
- add cs46xx, fix some other random crap

* Mon Jul 10 2000 Bill Nottingham <notting@redhat.com>
- fix ugly typo in i810 module name

* Thu Jun  1 2000 Bill Nottingham <notting@redhat.com>
- merge Sound-Boostar 16 3D with AD1816 - they're identical
- add YMF legacy, I810, and trident drivers

* Thu Jun  1 2000 Bill Nottingham <notting@redhat.com>
- conf.modules -> modules.conf

* Mon May 8 2000 Ngo Than <than@redhat.de>
- add support for Highscreen Sound-Boostar 16 3D

* Sun May  6 2000 Bill Nottingham <notting@redhat.com>
- hack up ia64 support

* Tue Feb  8 2000 Bill Nottingham <notting@redhat.com>
- sound-slot-0 fixes

* Wed Feb 02 2000 Cristian Gafton <gafton@redhat.com>
- fix description

* Mon Jan 31 2000 Bill Nottingham <notting@redhat.com>
- fix alias

* Mon Dec 20 1999 Bill Nottingham <notting@redhat.com>
- fix VIA chips

* Thu Sep 30 1999 Bill Nottingham <notting@redhat.com>
- add a '--quiet' autoconfiguration option

* Sat Sep 25 1999 Bill Nottingham <notting@redhat.com>
- add a warning about running under X

* Sat Sep 18 1999 Bill Nottingham <notting@redhat.com>
- add newtSuspend/newtResume around initial pnpdump

* Mon Sep 13 1999 Bill Nottingham <notting@redhat.com>
- add support for ESS Maestro & Neomagic MagicMedia 256AV
- only support cards for which there are modules

* Sat Sep 11 1999 Bill Nottingham <notting@redhat.com>
- add support for CMI8x38, VIA 82Cxxx, ESS Solo1

* Thu Sep  9 1999 Bill Nottingham <notting@redhat.com>
- kudzu-ify

* Tue Aug 24 1999 Bill Nottingham <notting@redhat.com>
- club AWE32 cards over the head. Bleah.

* Tue Aug 10 1999 Bill Nottingham <notting@redhat.com>
- oops, debugging code slipped in

* Mon Aug  9 1999 Bill Nottingham <notting@redhat.com>
- fix for sgalaxy

* Mon Aug  2 1999 Matt Wilson <msw@redhat.com>
- rebuilt against newt 0.50

* Thu Apr 22 1999 Bill Nottingham <notting@redhat.com>
- add "support" for a lot more PCI cards

* Mon Apr 19 1999 Cristian Gafton <gafton@redhat.com>
- release for Red Hat Linux 6.0

* Fri Apr  9 1999 Bill Nottingham <notting@redhat.com>
- allow both 0x530 & 0x534 as IO port choices for WSS based things

* Mon Apr  5 1999 Bill Nottingham <notting@redhat.com>
- add a double-extra sanity check for pci cards

* Wed Mar 17 1999 Bill Nottingham <notting@redhat.com>
- add a kludge for Vibra16X

* Thu Mar 11 1999 Bill Nottingham <notting@redhat.com>
- switch CMI8330 to use ad1848 driver
- rework Multisound Pinnacle support

* Tue Mar  9 1999 Jeff Johnson <jbj@redhat.com>
- add in_ID.po

* Tue Feb 23 1999 Bill Nottingham <notting@redhat.com>
- midi testing support

* Thu Feb 18 1999 Bill Nottingham <notting@redhat.com>
- add ALS100, add PnP support for it

* Thu Jan 28 1999 Bill Nottingham <notting@redhat.com>
- make everything use two dma= parameters

* Mon Jan 24 1999 Bill Nottingham <notting@redhat.com>
- card lists weren't in sync
- fix pci probing bug

* Sun Jan 10 1999 Bill Nottingham <notting@redhat.com>
- build against gpm (new newt)

* Mon Jan  4 1999 Bill Nottingham <notting@redhat.com>
- more PnP fixes (Opti PnP, CMI8330)
- require newer isapnptools so we don't run into LD bug.

* Mon Dec 28 1998 Bill Nottingham <notting@redhat.com>
- large pile of PnP fixes (Opti, SGalaxy, SSVIVO, ESS1868, others....)
- bump version to 0.29

* Thu Dec  3 1998 Bill Nottingham <notting@redhat.com>
- fix for SoundScape VIVO...

* Mon Nov 16 1998 Bill Nottingham <notting@redhat.com>
- awesfx goes in /bin

* Mon Nov  2 1998 Bill Nottingham <notting@redhat.com>
- added hack to make it less likely to lock up alphas

* Fri Oct 30 1998 Bill Nottingham <notting@redhat.com>
- stupid programmer error, part deux

* Thu Oct 22 1998 Bill Nottingham <notting@redhat.com>
- build for Raw Hide (slang-1.2.2)
- now for alpha
- organize by bus, not platform

* Wed Oct 14 1998 Cristian Gafton <gafton@redhat.com>
- translation updates

* Mon Oct 12 1998 Bill Nottingham <notting@redhat.com>
- fixes to lists of resources
- add more translations
- don't set auto-unload

* Thu Oct  8 1998 Bill Nottingham <notting@redhat.com>
- oops, forgot a newtResume()
- make /etc/conf.modules mode 0644, not 0600
- merge SBPCI entries with ES1370, since we can't tell them apart anyways

* Fri Oct  2 1998 Bill Nottingham <notting@redhat.com>
- added scrollbar to card list
- updated to 0.26

* Wed Sep 30 1998 Bill Nottingham <notting@redhat.com>
- fixes for AudioTrix Pro, add OPL3-SA2/3/x
- assorted random bugfixes
- add Turkish translations (from H. Turgut Uyar <uyar@cs.itu.edu.tr>)
- add Romanian translations

* Thu Sep 24 1998 Bill Nottingham <notting@redhat.com>
- add a few more cards
- disable Wavefront support for now

* Thu Sep 24 1998 Arnaldo Carvalho de Melo <acme@conectiva.com.br>
- added pt_BR translations
- i18n patches

* Wed Sep 23 1998 Bill Nottingham <notting@redhat.com>
- fix PCI-probing bug

* Tue Sep 22 1998 Bill Nottingham <notting@redhat.com>
- when merging isapnp.conf changes, use current preamble

* Fri Sep 18 1998 Bill Nottingham <notting@redhat.com>
- check that they actually have modular sound

* Fri Sep 11 1998 Bill Nottingham <notting@redhat.com>
- PCI probing!

* Tue Sep  8 1998 Bill Nottingham <notting@redhat.com>
- SPARC support.

* Wed Aug 26 1998 Bill Nottingham <notting@redhat.com>
- YABF

* Tue Aug 25 1998 Bill Nottingham <notting@redhat.com>
- fixed bad logic w/midi assignment

* Fri Aug 21 1998 Bill Nottingham <notting@redhat.com>
- fixed message segfault

* Thu Aug 20 1998 Bill Nottingham <notting@redhat.com>
- changed bug reporting address

* Wed Aug 19 1998 Bill Nottingham <notting@redhat.com>
- introduce support for non SB sound cards

* Sun Aug 02 1998 Erik Troan <ewt@redhat.com>
- built aginst newt 0.30

* Tue May 05 1998 Cristian Gafton <gafton@redhat.com>
- fixed problem with overwriting the conf.modules file

* Tue Dec 30 1997 Erik Troan <ewt@redhat.com>
- fixed problem w/ free()ing bad pointers

* Fri Dec 19 1997 Erik Troan <ewt@redhat.com>
- general Makefile cleanups

* Fri Nov  7 1997 Michael Fulbright <msf@redhat.com>
- fixed bug in reading current settings from conf.modules

* Fri Oct 31 1997 Michael Fulbright <msf@redhat.com>
- fixed behavior to work with rhsound service
- added support for midi in conf.modules, isapnp.conf
- reduced duplicate info stored in /etc/sysconfig/sound

* Wed Oct 29 1997 Mike Wangsmo <wanger@redhat.com>
- removed README's from tarball and coverted to buildroot

* Thu Oct 24 1997 Michael Fulbright <msf@redhat.com>
- added some docs on the sound modules

* Tue Oct 22 1997 Michael Fulbright <msf@redhat.com>
- changed sound sample to linux d00d instead of gorby d00d

* Tue Oct 14 1997 Michael Fulbright <msf@redhat.com>
- fixed creation of temporary files to be more secure.

* Mon Oct  6 1997 Michael Fulbright <msf@redhat.com>
- added man page

* Fri Oct  3 1997 Michael Fulbright <msf@redhat.com>
- first version
