/*==================================================================
 * pixmap.c - Handles the Smurf XPM pixmaps
 *
 * Smurf Sound Font Editor
 * Copyright (C) 1999-2001 Josh Green
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA or point your web browser to http://www.gnu.org.
 *
 * To contact the author of this program:
 * Email: Josh Green <jgreen@users.sourceforge.net>
 * Smurf homepage: http://smurf.sourceforge.net
 *==================================================================*/
#include <stdio.h>
#include <gtk/gtk.h>
#include "pixmap.h"
#include "uiface.h"

/* new pixmaps should be included here */

#include "../pixmaps/folder.xpm"
#include "../pixmaps/folder_open.xpm"
#include "../pixmaps/gen_ctrl.xpm"
#include "../pixmaps/gen_view.xpm"
#include "../pixmaps/gzone.xpm"
#include "../pixmaps/inst.xpm"
#include "../pixmaps/loaded.xpm"
#include "../pixmaps/mute.xpm"
#include "../pixmaps/piano.xpm"
#include "../pixmaps/preset.xpm"
#include "../pixmaps/rom.xpm"
#include "../pixmaps/sample.xpm"
#include "../pixmaps/samview.xpm"
#include "../pixmaps/seq_off.xpm"
#include "../pixmaps/seq_on.xpm"
#include "../pixmaps/velocity.xpm"

typedef struct {
  GdkPixmap *pixmap;
  GdkBitmap *mask;
} PixmapData;

/* hash of PixmapData structures, to keep track of converted XPMs */
static GHashTable *pixmap_hash = NULL;

/* gets the GdkPixmap and GdkBitmap structures associated with an XPM */
void
pixmap_get (gchar **xpm_data, GdkPixmap **pixmap, GdkBitmap **mask)
{
  GdkColormap *colormap;
  PixmapData *data;

  if (!pixmap_hash)
    pixmap_hash = g_hash_table_new (g_direct_hash, g_direct_equal);

  if (!(data = g_hash_table_lookup (pixmap_hash, xpm_data)))
    {
      data = g_malloc (sizeof (PixmapData));
      colormap = gtk_widget_get_colormap (GTK_WIDGET (ui_main_window));
      data->pixmap =
	gdk_pixmap_colormap_create_from_xpm_d (NULL, colormap,
					       &data->mask, NULL,
					       xpm_data);
      g_hash_table_insert (pixmap_hash, xpm_data, data);
    }

  *pixmap = data->pixmap;
  *mask = data->mask;
}
