/*
SMS Server Tools 3
Copyright (C) Keijo Kasvi
http://smstools3.kekekasvi.com/

Based on SMS Server Tools 2 from Stefan Frings
http://www.meinemullemaus.de/
SMS Server Tools version 2 and below are Copyright (C) Stefan Frings.

This program is free software unless you got it under another license directly
from the author. You can redistribute it and/or modify it under the terms of
the GNU General Public License as published by the Free Software Foundation.
Either version 2 of the License, or (at your option) any later version.
*/

#ifndef MODEMINIT_H
#define MODEMINIT_H

char *get_gsm_cme_error(int code);
char *get_gsm_cms_error(int code);
char *get_gsm_error(char *answer);

int write_to_modem(int modem, char *modemname, int send_delay, char *command, int timeout, int log_command, int print_error);
int read_from_modem(int modem, char *modemname, int send_delay, char *answer, int max, int timeout);

// Open the serial port, returns file handle or -1 on error
// Device is the name of serial port.
// modemname is a name for the modem, used for alarm_handler and logging
int openmodem(char* device, char* modemname); 

// Setup serial port
// modem is the file handle as returned by open()
// modemname is a name for the modem, used for alarm_handler and logging
// rtscts 0/1 enables hardware handshake
// baudrate is the baudrate as integer number
void setmodemparams(int modem, char* modemname, int rtscts, int baudrate);

// t_sleep returns 1 if terminate is set to 1 while sleeping:
int t_sleep(int seconds);

// Send init strings. 
// Returns 0 on success
//         1 modem is not ready
//         2 cannot enter pin
//         3 cannot enter init strings
//         4 modem is not registered
//         5 cannot enter pdu mode
//         6 cannot enter smsc number
//         7 seen that the thread is going to terminate

// modem is the file handle as returned by open()
// modemname is a name for the modem, used for alarm_handler and logging
// send_delay can be used to inser a delay between sending each character
// error_sleeptime number of seconds to sleep after ERROR answer
// pin is the pin for the SIM card (can be empty)
// initstring1 and initstring2 are two initialisation commands (can be empty)
// mode can me old, new or ascii
// smsc sets the sms service center (can be empty)
// check_network controls AT+CREG usage. If this fails, check_network is set to 0.
// pinsleeptime is number of seconds to sleep after a PIN is entered.
int initmodem(int device, int modem, char* modemname, int send_delay, int error_sleeptime, char* pin, char* initstring1, char* initstring2,
              char* smsc, int *check_network, int pinsleeptime, int pre_init);

// Sends a command to the modem and waits max timout*0.1 seconds for an answer.
// The function returns the length of the answer.
// The function waits until a timeout occurs or the expected answer occurs. 

// modem is the serial port file handle
// modemname is a name for the modem, used for alarm_handler and logging
// send_delay can be used to inser a delay between sending each character
// command is the command to send (may be empty or NULL)
// answer is the received answer
// max is the maxmum allowed size of the answer
// timeout control the time how long to wait for the answer
// expect is an extended regular expression. If this matches the modem answer, 
// then the program stops waiting for the timeout (may be empty or NULL).

int put_command(int modem, char *modemname, int send_delay, char *command, char *answer, int max, int timeout, char *expect);

int talk_with_modem(int device);

int wait_network_registration(int modem, char *modemname, int send_delay,
                              int *check_network, int error_sleeptime, int retry_count);

#endif
