/*
SMS Server Tools
Copyright (C) 2000 Stefan Frings

This program is free software unless you got it under another license directly
from the author. You can redistribute it and/or modify it under the terms of 
the GNU General Public License as published by the Free Software Foundation.
Either version 2 of the License, or (at your option) any later version.

http://www.isis.de/members/~s.frings
mailto:s.frings@mail.isis.de
*/

#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include "smsd_cfg.h"
#include "stats.h"
#include <syslog.h>

void initstats()
{
  int i;
  MM_create(DEVICES*sizeof(_stats),tempnam(0,0));
  for (i=0; i<DEVICES; i++)
  {
    if (statistics[i]=(_stats*)MM_malloc(sizeof(_stats)))
    {
      statistics[i]->succeeded_counter=0;
      statistics[i]->failed_counter=0;
      statistics[i]->received_counter=0;
      statistics[i]->multiple_failed_counter=0;
      statistics[i]->status='-';
      statistics[i]->usage_s=0;
      statistics[i]->usage_r=0;
    }
    else
    {
      syslog(LOG_ERR,"Cannot reserve memory for statistics.");
      exit(2);
    }
  }
  rejected_counter=0;
  start_time=time(0);
  last_stats=time(0);
}

void resetstats()
{
  int i;
  for (i=0; i<DEVICES; i++)
  {
    statistics[i]->succeeded_counter=0;
    statistics[i]->failed_counter=0;
    statistics[i]->received_counter=0;
    statistics[i]->multiple_failed_counter=0;
    statistics[i]->status='-';
    statistics[i]->usage_s=0;
    statistics[i]->usage_r=0;
  }
  rejected_counter=0;
  start_time=time(0);
  last_stats=time(0);
}

void savestats()
{
  FILE* datei;
  int i;
  time_t now=time(0);
  datei=fopen("/tmp/smsd_stats.tmp","w");  
  if (datei)
  {
    fwrite(&now,sizeof(now),1,datei);
    fwrite(&start_time,sizeof(start_time),1,datei);
    for (i=0; i<DEVICES; i++)
      fwrite(statistics[i],sizeof(_stats),1,datei);
    fclose(datei);
  }
  else
    syslog(LOG_ERR,"Cannot write tmp file for statistics.");    
}

void loadstats()
{
  FILE* datei;
  int i;
  time_t saved_time;
  datei=fopen("/tmp/smsd_stats.tmp","r");  
  if (datei)
  {
    fread(&saved_time,sizeof(time_t),1,datei);
    fread(&start_time,sizeof(time_t),1,datei);
    start_time=time(0)-(saved_time-start_time);
    for (i=0; i<DEVICES; i++)
    {
      fread(statistics[i],sizeof(_stats),1,datei);
      statistics[i]->status='-';
    }
    fclose(datei);
  }
}

void print_status()
{
  int j;
  if (printstatus)
  {
    for (j=0; j<DEVICES; j++)
      printf("%c",statistics[j]->status);
    printf("\n");
  }
}

void checkwritestats()
{
  time_t now,next_time;  
  char filename[256];
  char s[20];
  FILE* datei;
  int i;
  if (d_stats[0] && stats_interval)
  {
    next_time=last_stats+stats_interval;
    next_time=stats_interval*(next_time/stats_interval);  // round value
    now=time(0);
    if (now>=next_time) // reached timepoint of next stats file?
    {
      last_stats=time(0);
      strftime(s,sizeof(s),"%y%m%d.%H%M%S",localtime(&next_time));
      syslog(LOG_INFO,"Writing stats file %s",s);
      strcpy(filename,d_stats);
      strcat(filename,"/");
      strcat(filename,s);
      datei=fopen(filename,"w");
      if (datei)
      {
        fprintf(datei,"runtime,rejected\n");
	fprintf(datei,"%i,%i\n\n",now-start_time,rejected_counter);
	fprintf(datei,"name,succeeded,failed,received,multiple_failed,usage_s,usage_r\n");
	for (i=0; i<DEVICES; i++)
	{
	  if (devices[i].name[0])
  	    fprintf(datei,"%s,%i,%i,%i,%i,%i,%i\n",
	      devices[i].name,
	      statistics[i]->succeeded_counter,
	      statistics[i]->failed_counter,
	      statistics[i]->received_counter,
	      statistics[i]->multiple_failed_counter,
	      statistics[i]->usage_s,
	      statistics[i]->usage_r);
	}  
        fclose(datei);
	resetstats();
	last_stats=now;
      } 
      else
       syslog(LOG_ERR,"Cannot write statistic file.");    
    }    
  }    
}
