/*
 This file is part of slPIM.
 
 Copyright (c) 2001 John J. Ruthe <phaust@users.sourceforge.net>

 This program is free software; you can redistribute it and/or modify it
 under the terms of the GNU General Public License as published by the Free
 Software Foundation; either version 2 of the License, or (at your option)
 any later version.

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 more details.

 You should have received a copy of the GNU General Public License along
 with this program; if not, write to the Free Software Foundation, Inc., 675
 Mass Ave, Cambridge, MA 02139, USA. 
*/

#include <stdlib.h>
#include <getopt.h>
#include <stdio.h>
#include <time.h>
#include "defs.h"
#include "conf.h"
#include "screen.h"
#include "abook.h"

static int verbose_flag;

void slpim_mainmod_enter(void) {
	slpim_string_top = "a: addresbook";
	slpim_string_bot = "module selector **";
	slpim_write_message(NULL, INFO_MESSAGE);
}

int main(int argc, char **argv) {
	int i, j;
	struct option slpim_cmdline_opts[] = {
		{"verbose", no_argument, &verbose_flag, 1},
		{"query", optional_argument, NULL, 'q'},
		{"help", no_argument, NULL, 'h'},
		{0, 0, 0, 0}
	};

	/* initialization */
	srandom(time(NULL));

	/* parse commandline arguments */
	i = 0;
	do {
		j = getopt_long(argc, argv, "hvq::", slpim_cmdline_opts, &i);
		switch (j) {
			case 'v':
				verbose_flag = 1;
				break;
			case 'h':
				printf(" slPIM ver. %s (c) by John J. Ruthe <phaust@users.sourceforge.net>.\n", VERSION);
				printf(" There's no help available yet. Sorry.\n");
				exit(0);
			case 'q':
				/* printf(" QUERY %s\n", optarg); */
				j = slpim_do_config();
				if(j)
					exit(j);
				j = slpim_abook_mutt_query(optarg);
				exit(j);
			default:
		}
	} while (j != -1);

	if (verbose_flag)
		printf("Enterning verbose mode.\n");

	j = slpim_do_config();
	if(j)
		exit(j);
	
	/* screen init */
	slpim_screen_init();
	
	slpim_mainmod_enter();

	/* TODO - maybe some nice splashscreen :) */
				
	/* main code */
	i = j = 0;
	while(!j) {
		slpim_screen_refresh();
		i = slpim_getkey();
		switch(i) {
			/* TODO - other modules, so we'll be able to call them from here :) */
			case 'a':
				slpim_abook_main();
				slpim_mainmod_enter();
				break;
			case 'q':
				j = 1;
				break;
			default:
				slpim_write_message("What do you mean by this?", WARN_MESSAGE);
		}
	}
	

	/* finish */
	slpim_screen_finish();

	slpim_do_deconfig();

	printf("Thanks for using slPIM.\nBye.\n");
	
	return(0);
}

