
/* lexcount1 - ignore C comments, count all lines with non-whitespace. */
/* Read from stdin */
/* Basically, this is enough machinery to count the physical SLOC for
   a single file using C comments, e.g., lex. */

#include <stdio.h>
#include <ctype.h>

int peek() {
 int c = getchar();
 ungetc(c, stdin);
 return c;
}

main() {
 int c;
 int incomment = 0;
 long sloc = 0;
 int nonspace = 0;

 while ( (c = getchar()) != EOF) {
    if (!incomment) {
      if ((c == '/') && (peek() == '*')) {incomment=1;}
      else if (!isspace(c)) {nonspace = 1;}
    } else {
      if ((c == '*') && (peek() == '/')) {
           c= getchar(); c=getchar(); incomment=0;
      }
    }
    if ((c == '\n') && nonspace) {sloc++;}
 }
 printf("%ld\n", sloc);
}

