%  SLgtk: S-Lang language bindings for GTK+ widget set % {{{
%
%  Copyright (c) 2003-2005 Massachusetts Institute of Technology
%  Copyright (C) 2002 Michael S. Noble <mnoble@space.mit.edu>
%
%  This software was partially developed by the MIT Center for Space
%  Research under contract SV1-61010 from the Smithsonian Institution.
%  
%  Permission to use, copy, modify, distribute, and sell this software
%  and its documentation for any purpose is hereby granted without fee,
%  provided that the above copyright notice appear in all copies and
%  that both that copyright notice and this permission notice appear in
%  the supporting documentation, and that the name of the Massachusetts
%  Institute of Technology not be used in advertising or publicity
%  pertaining to distribution of the software without specific, written
%  prior permission.  The Massachusetts Institute of Technology makes
%  no representations about the suitability of this software for any
%  purpose.  It is provided "as is" without express or implied warranty.
%  
%  THE MASSACHUSETTS INSTITUTE OF TECHNOLOGY DISCLAIMS ALL WARRANTIES
%  WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF
%  MERCHANTABILITY AND FITNESS.  IN NO EVENT SHALL THE MASSACHUSETTS
%  INSTITUTE OF TECHNOLOGY BE LIABLE FOR ANY SPECIAL, INDIRECT OR
%  CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
%  OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
%  NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
%  WITH THE USE OR PERFORMANCE OF THIS SOFTWARE. }}}

% Front matter {{{

$1 = getenv("SLGTK_DIST_DIR");
if ($1 == NULL)
   $1 = "..";			% assume running from w/in examples dir

$2 = path_concat($1,"examples");
$3 = path_concat($1,"src");
$4 = path_concat($1,"packages");

set_slang_load_path ( sprintf("%s:%s:%s:%s",$2,$3,$4,get_slang_load_path()));
set_import_module_path ( sprintf("%s:%s",path_concat($1,"src"),
						get_import_module_path()));

variable SLGTK_EXAMPLES_DIR = $2;
variable SLGTK_IMAGES_DIR = path_concat($1, "images");

require("demoutils");
#ifeval _slang_version >= 20000
require("stkcheck");
#endif
% }}}

private define do_exit (widget, window) % {{{
{
   display_stack("do_exit");
   _slgtk_debug = 0;
   gtk_widget_destroy (window);
   gtk_main_quit ();
} % }}}

private define ttips_notify_test(ttips_obj,paramspec) % {{{
{
   variable quark = g_quark_from_static_string("oobie");
   g_param_spec_set_qdata(paramspec,quark,"doobie doo!");
} % }}}

private define create_mainwin() % {{{
{

   variable window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
   variable buffer = sprintf ("SLgtk %d.%d.%d",_slgtk_major_version,
	     		_slgtk_minor_version, _slgtk_micro_version);
   gtk_window_set_title(window, buffer);
   gtk_window_set_resizable(window, FALSE);
   gtk_widget_set_name (window, "main window");
   gtk_widget_set_usize (window, 200, 400);
   gtk_widget_set_uposition (window, 20, 20);

   % Notice that the function signature for _most_ signal callbacks should %{{{
   % have at least 2 parameters.  So, unlike the tests/testgtk.c example 
   % in the Gtk 2.2 distribution [which misleadingly uses gtk_main_quit() --
   % a function with a (void) prototype -- and thus relies upon the C runtime
   % to swallow unused stack arguments], we explicitly handle a destroy
   % signal on the top-level window with a correctly prototyped function.
   %
   % Elsewhere in the SLgtk examples code, though, it is demonstrated that
   % one need not pass _any_ so-called "data" parameter through to the
   % callback at the time of signal connection, _and_ that you may also pass
   % _more_ than one.
   %
   % Remember though, that, even if you do not register one or more data
   % parameters, EVERY callback will be passed at least one parameter (the 
   % object instance to which the signal is connected) at invocation.  This
   % means that every S-Lang callback function should expect at least one 
   % argument on the stack (i.e., _NARGS >= 1).
   %
   % Unlike C, the current implementation of S-Lang does not automatically
   % clean the stack for you, so if you pass data parameters to a callback
   % it's the responsibility of that function to ensure that they are not
   % left on the stack.  Usually this is done by defining (prototyping) the
   % callback func with the correct number of parameters, just like in C,
   % but the seasoned S-Lang programmer may also opt to define the function
   % with a void parameter list and then pop the arguments off explicitly
   % within the function body.  The latter is a powerful way to support
   % variable-length argument lists, among other things. % }}}

   () = g_signal_connect ( window, "destroy", &destroy_signal, window);

   % In likewise misleading fashion, the Gtk 2.2 tests/testgtk.c example uses
   % gtk_false() (another function which takes zero args) as the delete_event
   % callback, instead of a function which accepts 3 args.  There are ways
   % to have the S-Lang callbacks more gracefully handle mismatched argument
   % lists, but in this particular example I've opted for a pedantic approach
   % (of using an function explicitly prototyped to accept 3 args) to help 
   % raise SLgtk user awareness of the subtleties that can arise from S-Lang's
   % current approach to stack management.

   () = g_signal_connect ( window, "delete_event", &delete_event, NULL);

   variable main_vbox = gtk_vbox_new (FALSE, 0);
   gtk_container_add ( window, main_vbox);

   buffer = _slang_version_string;
   if (strlen(buffer) > 12) buffer = buffer[[:12]];
   buffer = sprintf ("S-Lang %s",buffer);
   variable label = gtk_label_new (buffer);
   gtk_box_pack_start ( main_vbox, label, FALSE, FALSE, 0);

   buffer = sprintf ("Gtk+ v%d.%d.%d",_gtk_major_version,
	     			_gtk_minor_version, _gtk_micro_version);
   label = gtk_label_new (buffer);
   gtk_box_pack_start ( main_vbox, label, FALSE, FALSE, 0);

   variable scrolled_window = gtk_scrolled_window_new (NULL, NULL);
   gtk_container_set_border_width ( (scrolled_window), 10);
   gtk_scrolled_window_set_policy (scrolled_window,
     		                  GTK_POLICY_AUTOMATIC, 
                                  GTK_POLICY_AUTOMATIC);
   gtk_box_pack_start ( main_vbox, scrolled_window, TRUE, TRUE, 0);

   variable vbox2 = gtk_vbox_new (FALSE, 0);
   gtk_container_set_border_width ( vbox2, 10);
   gtk_scrolled_window_add_with_viewport (scrolled_window, vbox2);

   foreach(testnames)
   {
	variable name = ();
	variable test = create_test(name);

	tests[name] = test;
	test.raise = gtk_button_new_with_label (test.name);
	if (test.func != NULL)
	   () = g_signal_connect_swapped (test.raise,"clicked",test.func,test);
	else
	   gtk_widget_set_sensitive (test.raise, FALSE);

	gtk_box_pack_start ( vbox2, test.raise, TRUE, TRUE, 0);
   }

   variable separator = gtk_hseparator_new ();
   gtk_box_pack_start ( main_vbox, separator, FALSE, TRUE, 0);

   variable hbox = gtk_hbox_new (FALSE, 10);
   gtk_container_set_border_width ( hbox, 10);
   gtk_box_pack_start ( main_vbox, hbox, FALSE, TRUE, 0);

   variable ttips = gtk_tooltips_new();
   g_object_set_data(window,"ttips",ttips);

   % Demonstrate that GObject instances may receive data/qdata
   g_object_set_data(ttips,"demo",5);

   % Demonstrate that GObject instances may have signals connected
   () = g_signal_connect(ttips,"notify",&ttips_notify_test);

   % Demonstrate that signal emission may be initiated on all GObject instances
   g_object_notify(ttips,"user-data");

   variable button = gtk_button_new_with_label ("Close");
   () = g_signal_connect (button,"clicked",&do_exit,window);
   gtk_box_pack_start (hbox, button, TRUE, TRUE, 0);
   gtk_widget_grab_focus(button);

   button = gtk_button_new_with_label ("Reload");
   gtk_tooltips_set_tip(ttips,button,"Press to reload S-Lang scripts "+
						"used by buttons above","");
   gtk_box_pack_start ( hbox, button, TRUE, TRUE, 0);
   () = g_signal_connect ( button, "clicked", &reload_tests);

   gtk_widget_show_all (window);

   return gtk_scrolled_window_get_vadjustment(scrolled_window);
} % }}}

_slgtk_debug = 1;
private variable scroller = create_mainwin(), i = 1, id = 0;

% Command line arg processing {{{
%   --check will enable slang2 stack checking
%   --auto cycles through all examples automatically
%   or file/example name will cause just _that_ example to run

while (i < __argc) {

   variable arg = __argv[i]; 
   i++;

   switch(arg)
   { case "--auto": !if (id) id = gtk_idle_add(&auto_raise,testnames,scroller);}
   { case "--check":
#ifeval _slang_version >= 20000
	enable_stack_check();
#endif
   }
   {
      	if (id) continue;
	(arg, ) = strreplace(arg, ".sl", "", -99);
	id = gtk_idle_add(&auto_raise,[arg], scroller);
   }
}
% }}}

gtk_main ();
